/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexBuilder;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.QBSubQueryParseInfo;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCheckCtx
implements NodeProcessorCtx {
    protected static final Logger LOG = LoggerFactory.getLogger(TypeCheckCtx.class);
    private RowResolver inputRR;
    private RowResolver outerRR;
    private Map<ASTNode, QBSubQueryParseInfo> subqueryToRelNode;
    private final boolean useCaching;
    private final boolean foldExpr;
    private UnparseTranslator unparseTranslator;
    private String error;
    private ASTNode errorSrcNode;
    private boolean allowStatefulFunctions;
    private boolean allowDistinctFunctions;
    private final boolean allowGBExprElimination;
    private final boolean allowAllColRef;
    private final boolean allowFunctionStar;
    private final boolean allowWindowing;
    private final boolean allowIndexExpr;
    private final boolean allowSubQueryExpr;
    private RexBuilder rexBuilder;
    private final List<String> columnAliases;

    public TypeCheckCtx(RowResolver inputRR) {
        this(inputRR, true, false);
    }

    public TypeCheckCtx(RowResolver inputRR, RexBuilder rexBuilder) {
        this(inputRR, rexBuilder, true, false);
    }

    public TypeCheckCtx(RowResolver inputRR, boolean useCaching, boolean foldExpr) {
        this(inputRR, useCaching, foldExpr, false, true, true, true, true, true, true, true);
    }

    public TypeCheckCtx(RowResolver inputRR, RexBuilder rexBuilder, boolean useCaching, boolean foldExpr) {
        this(inputRR, rexBuilder, useCaching, foldExpr, false, true, true, true, true, true, true, true);
    }

    public TypeCheckCtx(RowResolver inputRR, boolean useCaching, boolean foldExpr, boolean allowStatefulFunctions, boolean allowDistinctFunctions, boolean allowGBExprElimination, boolean allowAllColRef, boolean allowFunctionStar, boolean allowWindowing, boolean allowIndexExpr, boolean allowSubQueryExpr) {
        this(inputRR, null, useCaching, foldExpr, allowStatefulFunctions, allowDistinctFunctions, allowGBExprElimination, allowAllColRef, allowFunctionStar, allowWindowing, allowIndexExpr, allowSubQueryExpr);
    }

    public TypeCheckCtx(RowResolver inputRR, RexBuilder rexBuilder, boolean useCaching, boolean foldExpr, boolean allowStatefulFunctions, boolean allowDistinctFunctions, boolean allowGBExprElimination, boolean allowAllColRef, boolean allowFunctionStar, boolean allowWindowing, boolean allowIndexExpr, boolean allowSubQueryExpr) {
        this.setInputRR(inputRR);
        this.error = null;
        this.useCaching = useCaching;
        this.foldExpr = foldExpr;
        this.allowStatefulFunctions = allowStatefulFunctions;
        this.allowDistinctFunctions = allowDistinctFunctions;
        this.allowGBExprElimination = allowGBExprElimination;
        this.allowAllColRef = allowAllColRef;
        this.allowFunctionStar = allowFunctionStar;
        this.allowWindowing = allowWindowing;
        this.allowIndexExpr = allowIndexExpr;
        this.allowSubQueryExpr = allowSubQueryExpr;
        this.outerRR = null;
        this.subqueryToRelNode = null;
        this.rexBuilder = rexBuilder;
        this.columnAliases = new ArrayList<String>();
    }

    public void setInputRR(RowResolver inputRR) {
        this.inputRR = inputRR;
    }

    public RowResolver getInputRR() {
        return this.inputRR;
    }

    public void setOuterRR(RowResolver outerRR) {
        this.outerRR = outerRR;
    }

    public RowResolver getOuterRR() {
        return this.outerRR;
    }

    public void setSubqueryToRelNode(Map<ASTNode, QBSubQueryParseInfo> subqueryToRelNode) {
        this.subqueryToRelNode = subqueryToRelNode;
    }

    public Map<ASTNode, QBSubQueryParseInfo> getSubqueryToRelNode() {
        return this.subqueryToRelNode;
    }

    public void setUnparseTranslator(UnparseTranslator unparseTranslator) {
        this.unparseTranslator = unparseTranslator;
    }

    public UnparseTranslator getUnparseTranslator() {
        return this.unparseTranslator;
    }

    public void setAllowStatefulFunctions(boolean allowStatefulFunctions) {
        this.allowStatefulFunctions = allowStatefulFunctions;
    }

    public boolean getAllowStatefulFunctions() {
        return this.allowStatefulFunctions;
    }

    public void setError(String error, ASTNode errorSrcNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting error: [" + error + "] from " + (errorSrcNode == null ? "null" : errorSrcNode.toStringTree()));
        }
        this.error = error;
        this.errorSrcNode = errorSrcNode;
    }

    public String getError() {
        return this.error;
    }

    public ASTNode getErrorSrcNode() {
        return this.errorSrcNode;
    }

    public void setAllowDistinctFunctions(boolean allowDistinctFunctions) {
        this.allowDistinctFunctions = allowDistinctFunctions;
    }

    public boolean getAllowDistinctFunctions() {
        return this.allowDistinctFunctions;
    }

    public boolean getAllowGBExprElimination() {
        return this.allowGBExprElimination;
    }

    public boolean getallowAllColRef() {
        return this.allowAllColRef;
    }

    public boolean getallowFunctionStar() {
        return this.allowFunctionStar;
    }

    public boolean getallowWindowing() {
        return this.allowWindowing;
    }

    public boolean getallowIndexExpr() {
        return this.allowIndexExpr;
    }

    public boolean getallowSubQueryExpr() {
        return this.allowSubQueryExpr;
    }

    public boolean isUseCaching() {
        return this.useCaching;
    }

    public boolean isFoldExpr() {
        return this.foldExpr;
    }

    public boolean isCBOExecuted() {
        return this.foldExpr;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public void addColumnAlias(String alias) {
        this.columnAliases.add(alias);
    }

    public List<String> getColumnAliases() {
        return this.columnAliases;
    }
}

