/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;

public class JDBCFilterJoinRule
extends HiveFilterJoinRule {
    public static final JDBCFilterJoinRule INSTANCE = new JDBCFilterJoinRule();

    public JDBCFilterJoinRule() {
        super(RelOptRule.operand(HiveFilter.class, (RelOptRuleOperand)RelOptRule.operand(HiveJoin.class, (RelOptRuleOperand)RelOptRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{RelOptRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)RelOptRule.any())}), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "JDBCFilterJoinRule");
    }

    public boolean matches(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Join join = (Join)call.rel(1);
        HiveJdbcConverter conv1 = (HiveJdbcConverter)call.rel(2);
        HiveJdbcConverter conv2 = (HiveJdbcConverter)call.rel(3);
        if (!conv1.getJdbcDialect().equals(conv2.getJdbcDialect())) {
            return false;
        }
        boolean visitorRes = JDBCRexCallValidator.isValidJdbcOperation(filter.getCondition(), conv1.getJdbcDialect());
        if (visitorRes) {
            return JDBCRexCallValidator.isValidJdbcOperation(join.getCondition(), conv1.getJdbcDialect());
        }
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Join join = (Join)call.rel(1);
        super.perform(call, filter, join);
    }
}

