/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.security.BaseNMTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMTokenSecretManagerInRM
extends BaseNMTokenSecretManager {
    private static final Logger LOG = LoggerFactory.getLogger(NMTokenSecretManagerInRM.class);
    private MasterKeyData nextMasterKey;
    private Configuration conf;
    private final Timer timer;
    private final long rollingInterval;
    private final long activationDelay;
    private final ConcurrentHashMap<ApplicationAttemptId, HashSet<NodeId>> appAttemptToNodeKeyMap;

    public NMTokenSecretManagerInRM(Configuration conf) {
        this.conf = conf;
        this.timer = new Timer();
        this.rollingInterval = this.conf.getLong("yarn.resourcemanager.nm-tokens.master-key-rolling-interval-secs", 86400L) * 1000L;
        this.activationDelay = (long)((double)conf.getLong("yarn.nm.liveness-monitor.expiry-interval-ms", 600000L) * 1.5);
        LOG.info("NMTokenKeyRollingInterval: " + this.rollingInterval + "ms and NMTokenKeyActivationDelay: " + this.activationDelay + "ms");
        if (this.rollingInterval <= this.activationDelay * 2L) {
            throw new IllegalArgumentException("yarn.resourcemanager.nm-tokens.master-key-rolling-interval-secs should be more than 3 X yarn.nm.liveness-monitor.expiry-interval-ms");
        }
        this.appAttemptToNodeKeyMap = new ConcurrentHashMap();
    }

    @InterfaceAudience.Private
    public void rollMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info("Rolling master-key for nm-tokens");
            if (this.currentMasterKey == null) {
                this.currentMasterKey = this.createNewMasterKey();
            } else {
                this.nextMasterKey = this.createNewMasterKey();
                LOG.info("Going to activate master-key with key-id " + this.nextMasterKey.getMasterKey().getKeyId() + " in " + this.activationDelay + "ms");
                this.timer.schedule((TimerTask)new NextKeyActivator(), this.activationDelay);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public MasterKey getNextKey() {
        this.readLock.lock();
        try {
            if (this.nextMasterKey == null) {
                MasterKey masterKey = null;
                return masterKey;
            }
            MasterKey masterKey = this.nextMasterKey.getMasterKey();
            return masterKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public void activateNextMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info("Activating next master key with id: " + this.nextMasterKey.getMasterKey().getKeyId());
            this.currentMasterKey = this.nextMasterKey;
            this.nextMasterKey = null;
            this.clearApplicationNMTokenKeys();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearNodeSetForAttempt(ApplicationAttemptId attemptId) {
        this.writeLock.lock();
        try {
            HashSet<NodeId> nodeSet = this.appAttemptToNodeKeyMap.get(attemptId);
            if (nodeSet != null) {
                LOG.info("Clear node set for " + attemptId);
                nodeSet.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearApplicationNMTokenKeys() {
        Iterator<HashSet<NodeId>> nodeSetI = this.appAttemptToNodeKeyMap.values().iterator();
        while (nodeSetI.hasNext()) {
            nodeSetI.next().clear();
        }
    }

    public void start() {
        this.rollMasterKey();
        this.timer.scheduleAtFixedRate((TimerTask)new MasterKeyRoller(), this.rollingInterval, this.rollingInterval);
    }

    public void stop() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMToken createAndGetNMToken(String applicationSubmitter, ApplicationAttemptId appAttemptId, Container container) {
        this.writeLock.lock();
        try {
            HashSet<NodeId> nodeSet = this.appAttemptToNodeKeyMap.get(appAttemptId);
            NMToken nmToken = null;
            if (nodeSet != null && !nodeSet.contains(container.getNodeId())) {
                LOG.debug("Sending NMToken for nodeId : {} for container : {}", (Object)container.getNodeId(), (Object)container.getId());
                Token token = this.createNMToken(container.getId().getApplicationAttemptId(), container.getNodeId(), applicationSubmitter);
                nmToken = NMToken.newInstance((NodeId)container.getNodeId(), (Token)token);
                nodeSet.add(container.getNodeId());
            }
            NMToken nMToken = nmToken;
            return nMToken;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void registerApplicationAttempt(ApplicationAttemptId appAttemptId) {
        this.writeLock.lock();
        try {
            this.appAttemptToNodeKeyMap.put(appAttemptId, new HashSet());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isApplicationAttemptRegistered(ApplicationAttemptId appAttemptId) {
        this.readLock.lock();
        try {
            boolean bl = this.appAttemptToNodeKeyMap.containsKey(appAttemptId);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isApplicationAttemptNMTokenPresent(ApplicationAttemptId appAttemptId, NodeId nodeId) {
        this.readLock.lock();
        try {
            HashSet<NodeId> nodes = this.appAttemptToNodeKeyMap.get(appAttemptId);
            if (nodes != null && nodes.contains(nodeId)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void unregisterApplicationAttempt(ApplicationAttemptId appAttemptId) {
        this.writeLock.lock();
        try {
            this.appAttemptToNodeKeyMap.remove(appAttemptId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeNodeKey(NodeId nodeId) {
        this.writeLock.lock();
        try {
            Iterator<HashSet<NodeId>> appNodeKeySetIterator = this.appAttemptToNodeKeyMap.values().iterator();
            while (appNodeKeySetIterator.hasNext()) {
                appNodeKeySetIterator.next().remove(nodeId);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private class NextKeyActivator
    extends TimerTask {
        private NextKeyActivator() {
        }

        @Override
        public void run() {
            NMTokenSecretManagerInRM.this.activateNextMasterKey();
        }
    }

    private class MasterKeyRoller
    extends TimerTask {
        private MasterKeyRoller() {
        }

        @Override
        public void run() {
            NMTokenSecretManagerInRM.this.rollMasterKey();
        }
    }
}

