/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMParams;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsController;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebServices;
import org.apache.hadoop.mapreduce.v2.hs.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;

public class HsWebApp
extends WebApp
implements AMParams {
    private HistoryContext history;

    public HsWebApp(HistoryContext history) {
        this.history = history;
    }

    public void setup() {
        this.bind(HsWebServices.class);
        this.bind(JAXBContextResolver.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(AppContext.class).toInstance((Object)this.history);
        this.bind(HistoryContext.class).toInstance((Object)this.history);
        this.route("/", HsController.class);
        this.route("/app", HsController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/job", "job.id"}), HsController.class, "job");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/conf", "job.id"}), HsController.class, "conf");
        this.routeWithoutDefaultView(StringHelper.pajoin((Object[])new Object[]{"/downloadconf", "job.id"}), HsController.class, "downloadConf");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/jobcounters", "job.id"}), HsController.class, "jobCounters");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/singlejobcounter", "job.id", "counter.group", "counter.name"}), HsController.class, "singleJobCounter");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/tasks", "job.id", "task.type"}), HsController.class, "tasks");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/attempts", "job.id", "task.type", "attempt.state"}), HsController.class, "attempts");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/task", "task.id"}), HsController.class, "task");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/taskcounters", "task.id"}), HsController.class, "taskCounters");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/singletaskcounter", "task.id", "counter.group", "counter.name"}), HsController.class, "singleTaskCounter");
        this.route("/about", HsController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/logs", "nm.id", "container.id", "entity.string", "app.owner", "log.type"}), HsController.class, "logs");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nmlogs", "nm.id", "container.id", "entity.string", "app.owner", "log.type"}), HsController.class, "nmlogs");
    }
}

