/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestRegionLocator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRegionLocator
extends AbstractTestRegionLocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLocator.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRegionLocator.startClusterAndCreateTable();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Override
    protected byte[][] getStartKeys(TableName tableName) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            byte[][] byArray = locator.getStartKeys();
            return byArray;
        }
    }

    @Override
    protected byte[][] getEndKeys(TableName tableName) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            byte[][] byArray = locator.getEndKeys();
            return byArray;
        }
    }

    @Override
    protected Pair<byte[][], byte[][]> getStartEndKeys(TableName tableName) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            Pair pair = locator.getStartEndKeys();
            return pair;
        }
    }

    @Override
    protected HRegionLocation getRegionLocation(TableName tableName, byte[] row, int replicaId) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            HRegionLocation hRegionLocation = locator.getRegionLocation(row, replicaId);
            return hRegionLocation;
        }
    }

    @Override
    protected List<HRegionLocation> getRegionLocations(TableName tableName, byte[] row) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            List list = locator.getRegionLocations(row);
            return list;
        }
    }

    @Override
    protected List<HRegionLocation> getAllRegionLocations(TableName tableName) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            List list = locator.getAllRegionLocations();
            return list;
        }
    }

    @Override
    protected void clearCache(TableName tableName) throws IOException {
        try (RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            locator.clearRegionLocationCache();
        }
    }
}

