/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DescriptionUtils;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class MatchingRuleUse
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    private List<String> applicableAttributeOids = new ArrayList<String>();
    private List<AttributeType> applicableAttributes = new ArrayList<AttributeType>();

    public MatchingRuleUse(String oid) {
        super(SchemaObjectType.MATCHING_RULE_USE, oid);
    }

    public List<String> getApplicableAttributeOids() {
        return this.applicableAttributeOids;
    }

    public List<AttributeType> getApplicableAttributes() {
        return this.applicableAttributes;
    }

    public void setApplicableAttributeOids(List<String> applicableAttributeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.applicableAttributeOids = applicableAttributeOids;
        }
    }

    public void setApplicableAttributes(List<AttributeType> applicableAttributes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.applicableAttributes = applicableAttributes;
            this.applicableAttributeOids.clear();
            for (AttributeType at : applicableAttributes) {
                this.applicableAttributeOids.add(at.getOid());
            }
        }
    }

    public void addApplicableAttributeOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly && !this.applicableAttributeOids.contains(oid)) {
            this.applicableAttributeOids.add(oid);
        }
    }

    public void addApplicableAttribute(AttributeType attributeType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly && !this.applicableAttributeOids.contains(attributeType.getOid())) {
            this.applicableAttributes.add(attributeType);
            this.applicableAttributeOids.add(attributeType.getOid());
        }
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public MatchingRuleUse copy() {
        MatchingRuleUse copy = new MatchingRuleUse(this.oid);
        copy.copy(this);
        copy.applicableAttributeOids = new ArrayList<String>();
        for (String oid : this.applicableAttributeOids) {
            copy.applicableAttributeOids.add(oid);
        }
        copy.applicableAttributes = new ArrayList<AttributeType>();
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MatchingRuleUse)) {
            return false;
        }
        MatchingRuleUse that = (MatchingRuleUse)o;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.applicableAttributes.clear();
        this.applicableAttributeOids.clear();
    }
}

