/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AcidGuaranteesTestTool;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestAcidGuarantees
extends IntegrationTestBase {
    private static final int SERVER_COUNT = 1;
    AcidGuaranteesTestTool tool;

    @Override
    public int runTestFromCommandLine() throws Exception {
        return this.tool.run(new String[0]);
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.util.initializeCluster(1);
        this.conf = this.getConf();
        this.conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(131072));
        this.conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        this.tool = new AcidGuaranteesTestTool();
        this.tool.setConf(this.getConf());
    }

    @Override
    public TableName getTablename() {
        return AcidGuaranteesTestTool.TABLE_NAME;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])AcidGuaranteesTestTool.FAMILY_A), Bytes.toString((byte[])AcidGuaranteesTestTool.FAMILY_B), Bytes.toString((byte[])AcidGuaranteesTestTool.FAMILY_C)});
    }

    private void runTestAtomicity(long millisToRun, int numWriters, int numGetters, int numScanners, int numUniqueRows) throws Exception {
        this.tool.run(new String[]{"-millis", String.valueOf(millisToRun), "-numWriters", String.valueOf(numWriters), "-numGetters", String.valueOf(numGetters), "-numScanners", String.valueOf(numScanners), "-numUniqueRows", String.valueOf(numUniqueRows)});
    }

    @Test
    public void testGetAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 4, 4, 0, 3);
    }

    @Test
    public void testScanAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 3, 0, 2, 3);
    }

    @Test
    public void testMixedAtomicity() throws Exception {
        this.runTestAtomicity(20000L, 4, 2, 2, 3);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestAcidGuarantees(), (String[])args);
        System.exit(ret);
    }
}

