/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.errorprone.annotations.RestrictedApi;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalancerDecision;
import org.apache.hadoop.hbase.client.BalancerRejection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.LoadCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.LocalityBasedCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.MemStoreSizeCostFunction;
import org.apache.hadoop.hbase.master.balancer.MetricsStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.MoveCostFunction;
import org.apache.hadoop.hbase.master.balancer.PrimaryRegionCountSkewCostFunction;
import org.apache.hadoop.hbase.master.balancer.RackLocalityCostFunction;
import org.apache.hadoop.hbase.master.balancer.RandomCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.ReadRequestCostFunction;
import org.apache.hadoop.hbase.master.balancer.RegionCountSkewCostFunction;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaHostCostFunction;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaRackCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaRackCostFunction;
import org.apache.hadoop.hbase.master.balancer.ServerLocalityCostFunction;
import org.apache.hadoop.hbase.master.balancer.StoreFileCostFunction;
import org.apache.hadoop.hbase.master.balancer.TableSkewCostFunction;
import org.apache.hadoop.hbase.master.balancer.WriteRequestCostFunction;
import org.apache.hadoop.hbase.namequeues.BalancerDecisionDetails;
import org.apache.hadoop.hbase.namequeues.BalancerRejectionDetails;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Suppliers;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class StochasticLoadBalancer
extends BaseLoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(StochasticLoadBalancer.class);
    protected static final String STEPS_PER_REGION_KEY = "hbase.master.balancer.stochastic.stepsPerRegion";
    protected static final int DEFAULT_STEPS_PER_REGION = 800;
    protected static final String MAX_STEPS_KEY = "hbase.master.balancer.stochastic.maxSteps";
    protected static final int DEFAULT_MAX_STEPS = 1000000;
    protected static final String RUN_MAX_STEPS_KEY = "hbase.master.balancer.stochastic.runMaxSteps";
    protected static final boolean DEFAULT_RUN_MAX_STEPS = false;
    protected static final String MAX_RUNNING_TIME_KEY = "hbase.master.balancer.stochastic.maxRunningTime";
    protected static final long DEFAULT_MAX_RUNNING_TIME = 30000L;
    protected static final String KEEP_REGION_LOADS = "hbase.master.balancer.stochastic.numRegionLoadsToRemember";
    protected static final int DEFAULT_KEEP_REGION_LOADS = 15;
    private static final String TABLE_FUNCTION_SEP = "_";
    protected static final String MIN_COST_NEED_BALANCE_KEY = "hbase.master.balancer.stochastic.minCostNeedBalance";
    protected static final float DEFAULT_MIN_COST_NEED_BALANCE = 0.025f;
    protected static final String COST_FUNCTIONS_COST_FUNCTIONS_KEY = "hbase.master.balancer.stochastic.additionalCostFunctions";
    public static final String OVERALL_COST_FUNCTION_NAME = "Overall";
    Map<String, Deque<BalancerRegionLoad>> loads = new HashMap<String, Deque<BalancerRegionLoad>>();
    private int maxSteps = 1000000;
    private boolean runMaxSteps = false;
    private int stepsPerRegion = 800;
    private long maxRunningTime = 30000L;
    private int numRegionLoadsToRemember = 15;
    private float minCostNeedBalance = 0.025f;
    private boolean isBalancerDecisionRecording = false;
    private boolean isBalancerRejectionRecording = false;
    Map<String, Pair<ServerName, Float>> regionCacheRatioOnOldServerMap = new HashMap<String, Pair<ServerName, Float>>();
    protected List<CostFunction> costFunctions;
    private float sumMultiplier;
    private double curOverallCost = 0.0;
    private double[] tempFunctionCosts;
    private double[] curFunctionCosts;
    private LocalityBasedCandidateGenerator localityCandidateGenerator;
    private ServerLocalityCostFunction localityCost;
    private RackLocalityCostFunction rackLocalityCost;
    private RegionReplicaHostCostFunction regionReplicaHostCostFunction;
    private RegionReplicaRackCostFunction regionReplicaRackCostFunction;
    NamedQueueRecorder namedQueueRecorder;
    private final Map<Class<? extends CandidateGenerator>, Double> weightsOfGenerators = new HashMap<Class<? extends CandidateGenerator>, Double>();
    protected Map<Class<? extends CandidateGenerator>, CandidateGenerator> candidateGenerators;
    protected final Supplier<List<Class<? extends CandidateGenerator>>> shuffledGeneratorClasses = Suppliers.memoizeWithExpiration(() -> {
        ArrayList<Class<? extends CandidateGenerator>> shuffled = new ArrayList<Class<? extends CandidateGenerator>>(this.candidateGenerators.keySet());
        Collections.shuffle(shuffled);
        return shuffled;
    }, (long)5L, (TimeUnit)TimeUnit.SECONDS);

    public StochasticLoadBalancer() {
        super(new MetricsStochasticBalancer());
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public StochasticLoadBalancer(MetricsStochasticBalancer metricsStochasticBalancer) {
        super(metricsStochasticBalancer);
    }

    private static CostFunction createCostFunction(Class<? extends CostFunction> clazz, Configuration conf) {
        try {
            Constructor<? extends CostFunction> ctor = clazz.getDeclaredConstructor(Configuration.class);
            return (CostFunction)ReflectionUtils.instantiate((String)clazz.getName(), ctor, (Object[])new Object[]{conf});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (CostFunction)ReflectionUtils.newInstance(clazz, (Object[])new Object[0]);
        }
    }

    private void loadCustomCostFunctions(Configuration conf) {
        String[] functionsNames = conf.getStrings(COST_FUNCTIONS_COST_FUNCTIONS_KEY);
        if (null == functionsNames) {
            return;
        }
        for (String className : functionsNames) {
            Class<CostFunction> clazz;
            try {
                clazz = Class.forName(className).asSubclass(CostFunction.class);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot load class '{}': {}", (Object)className, (Object)e.getMessage());
                continue;
            }
            CostFunction func = StochasticLoadBalancer.createCostFunction(clazz, conf);
            LOG.info("Successfully loaded custom CostFunction '{}'", (Object)func.getClass().getSimpleName());
            this.costFunctions.add(func);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    Map<Class<? extends CandidateGenerator>, CandidateGenerator> getCandidateGenerators() {
        return this.candidateGenerators;
    }

    protected Map<Class<? extends CandidateGenerator>, CandidateGenerator> createCandidateGenerators() {
        HashMap<Class<? extends CandidateGenerator>, CandidateGenerator> candidateGenerators = new HashMap<Class<? extends CandidateGenerator>, CandidateGenerator>(5);
        candidateGenerators.put(RandomCandidateGenerator.class, new RandomCandidateGenerator());
        candidateGenerators.put(LoadCandidateGenerator.class, new LoadCandidateGenerator());
        candidateGenerators.put(LocalityBasedCandidateGenerator.class, this.localityCandidateGenerator);
        candidateGenerators.put(RegionReplicaCandidateGenerator.class, new RegionReplicaCandidateGenerator());
        candidateGenerators.put(RegionReplicaRackCandidateGenerator.class, new RegionReplicaRackCandidateGenerator());
        return candidateGenerators;
    }

    protected List<CostFunction> createCostFunctions(Configuration conf) {
        ArrayList<CostFunction> costFunctions = new ArrayList<CostFunction>();
        this.addCostFunction(costFunctions, new RegionCountSkewCostFunction(conf));
        this.addCostFunction(costFunctions, new PrimaryRegionCountSkewCostFunction(conf));
        this.addCostFunction(costFunctions, new MoveCostFunction(conf));
        this.addCostFunction(costFunctions, this.localityCost);
        this.addCostFunction(costFunctions, this.rackLocalityCost);
        this.addCostFunction(costFunctions, new TableSkewCostFunction(conf));
        this.addCostFunction(costFunctions, this.regionReplicaHostCostFunction);
        this.addCostFunction(costFunctions, this.regionReplicaRackCostFunction);
        this.addCostFunction(costFunctions, new ReadRequestCostFunction(conf));
        this.addCostFunction(costFunctions, new WriteRequestCostFunction(conf));
        this.addCostFunction(costFunctions, new MemStoreSizeCostFunction(conf));
        this.addCostFunction(costFunctions, new StoreFileCostFunction(conf));
        return costFunctions;
    }

    @Override
    protected void loadConf(Configuration conf) {
        super.loadConf(conf);
        this.maxSteps = conf.getInt(MAX_STEPS_KEY, 1000000);
        this.stepsPerRegion = conf.getInt(STEPS_PER_REGION_KEY, 800);
        this.maxRunningTime = conf.getLong(MAX_RUNNING_TIME_KEY, 30000L);
        this.runMaxSteps = conf.getBoolean(RUN_MAX_STEPS_KEY, false);
        this.numRegionLoadsToRemember = conf.getInt(KEEP_REGION_LOADS, 15);
        this.minCostNeedBalance = conf.getFloat(MIN_COST_NEED_BALANCE_KEY, 0.025f);
        this.localityCandidateGenerator = new LocalityBasedCandidateGenerator();
        this.localityCost = new ServerLocalityCostFunction(conf);
        this.rackLocalityCost = new RackLocalityCostFunction(conf);
        this.candidateGenerators = this.createCandidateGenerators();
        this.regionReplicaHostCostFunction = new RegionReplicaHostCostFunction(conf);
        this.regionReplicaRackCostFunction = new RegionReplicaRackCostFunction(conf);
        this.costFunctions = this.createCostFunctions(conf);
        this.loadCustomCostFunctions(conf);
        this.curFunctionCosts = new double[this.costFunctions.size()];
        this.tempFunctionCosts = new double[this.costFunctions.size()];
        this.isBalancerDecisionRecording = conf.getBoolean("hbase.master.balancer.decision.buffer.enabled", false);
        this.isBalancerRejectionRecording = conf.getBoolean("hbase.master.balancer.rejection.buffer.enabled", false);
        if (this.namedQueueRecorder == null && (this.isBalancerDecisionRecording || this.isBalancerRejectionRecording)) {
            this.namedQueueRecorder = NamedQueueRecorder.getInstance(conf);
        }
        LOG.info("Loaded config; maxSteps=" + this.maxSteps + ", runMaxSteps=" + this.runMaxSteps + ", stepsPerRegion=" + this.stepsPerRegion + ", maxRunningTime=" + this.maxRunningTime + ", isByTable=" + this.isByTable + ", CostFunctions=" + Arrays.toString(this.getCostFunctionNames()) + " , sum of multiplier of cost functions = " + this.sumMultiplier + " etc.");
    }

    @Override
    public synchronized void updateClusterMetrics(ClusterMetrics st) {
        super.updateClusterMetrics(st);
        this.updateRegionLoad();
        try {
            int tablesCount = this.isByTable ? this.services.getTableDescriptors().getAll().size() : 1;
            int functionsCount = this.getCostFunctionNames().length;
            this.updateMetricsSize(tablesCount * (functionsCount + 1));
        }
        catch (Exception e) {
            LOG.error("failed to get the size of all tables", (Throwable)e);
        }
    }

    private void updateBalancerTableLoadInfo(TableName tableName, Map<ServerName, List<RegionInfo>> loadOfOneTable) {
        RegionLocationFinder finder = null;
        if (this.localityCost != null && this.localityCost.getMultiplier() > 0.0f || this.rackLocalityCost != null && this.rackLocalityCost.getMultiplier() > 0.0f) {
            finder = this.regionFinder;
        }
        BalancerClusterState cluster = new BalancerClusterState(loadOfOneTable, this.loads, finder, this.rackManager);
        this.initCosts(cluster);
        this.curOverallCost = this.computeCost(cluster, Double.MAX_VALUE);
        System.arraycopy(this.tempFunctionCosts, 0, this.curFunctionCosts, 0, this.curFunctionCosts.length);
        this.updateStochasticCosts(tableName, this.curOverallCost, this.curFunctionCosts);
    }

    @Override
    public void updateBalancerLoadInfo(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) {
        if (this.isByTable) {
            loadOfAllTable.forEach((tableName, loadOfOneTable) -> this.updateBalancerTableLoadInfo((TableName)tableName, (Map<ServerName, List<RegionInfo>>)loadOfOneTable));
        } else {
            this.updateBalancerTableLoadInfo(HConstants.ENSEMBLE_TABLE_NAME, this.toEnsumbleTableLoad(loadOfAllTable));
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    void updateMetricsSize(int size) {
        if (this.metricsBalancer instanceof MetricsStochasticBalancer) {
            ((MetricsStochasticBalancer)this.metricsBalancer).updateMetricsSize(size);
        }
    }

    private boolean areSomeRegionReplicasColocatedOnHost(BalancerClusterState c) {
        if (c.numHosts >= c.maxReplicas) {
            boolean colocatedAtHost;
            this.regionReplicaHostCostFunction.prepare(c);
            double hostCost = Math.abs(this.regionReplicaHostCostFunction.cost());
            boolean bl = colocatedAtHost = hostCost > CostFunction.getCostEpsilon(hostCost);
            if (colocatedAtHost) {
                return true;
            }
            LOG.trace("No host colocation detected with host cost={}", (Object)hostCost);
        }
        return false;
    }

    private boolean areSomeRegionReplicasColocatedOnRack(BalancerClusterState c) {
        if (c.numRacks >= c.maxReplicas) {
            boolean colocatedAtRack;
            this.regionReplicaRackCostFunction.prepare(c);
            double rackCost = Math.abs(this.regionReplicaRackCostFunction.cost());
            boolean bl = colocatedAtRack = rackCost > CostFunction.getCostEpsilon(rackCost);
            if (colocatedAtRack) {
                return true;
            }
            LOG.trace("No rack colocation detected with rack cost={}", (Object)rackCost);
        } else {
            LOG.trace("Rack colocation is inevitable with fewer racks than replicas, so we won't bother checking");
        }
        return false;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    boolean needsBalance(TableName tableName, BalancerClusterState cluster) {
        boolean balanced;
        ClusterLoadState cs = new ClusterLoadState(cluster.clusterState);
        if (cs.getNumServers() < 2) {
            LOG.info("Not running balancer because only " + cs.getNumServers() + " active regionserver(s)");
            this.sendRejectionReasonToRingBuffer("The number of RegionServers " + cs.getNumServers() + " < MIN_SERVER_BALANCE(" + 2 + ")", null);
            return false;
        }
        if (this.areSomeRegionReplicasColocatedOnHost(cluster)) {
            LOG.info("Running balancer because at least one server hosts replicas of the same region. function cost={}", (Object)this.functionCost());
            return true;
        }
        if (this.areSomeRegionReplicasColocatedOnRack(cluster)) {
            LOG.info("Running balancer because at least one rack hosts replicas of the same region. function cost={}", (Object)this.functionCost());
            return true;
        }
        if (this.idleRegionServerExist(cluster)) {
            LOG.info("Running balancer because cluster has idle server(s). function cost={}", (Object)this.functionCost());
            return true;
        }
        if (this.sloppyRegionServerExist(cs)) {
            LOG.info("Running balancer because cluster has sloppy server(s). function cost={}", (Object)this.functionCost());
            return true;
        }
        double total = 0.0;
        float localSumMultiplier = 0.0f;
        for (CostFunction c : this.costFunctions) {
            if (!c.isNeeded()) {
                LOG.trace("{} not needed", (Object)c.getClass().getSimpleName());
                continue;
            }
            total += c.cost() * (double)c.getMultiplier();
            localSumMultiplier += c.getMultiplier();
        }
        this.sumMultiplier = localSumMultiplier;
        boolean bl = balanced = total / (double)this.sumMultiplier < (double)this.minCostNeedBalance;
        if (balanced) {
            if (this.isBalancerRejectionRecording) {
                String reason = "";
                if (total <= 0.0) {
                    reason = "(cost1*multiplier1)+(cost2*multiplier2)+...+(costn*multipliern) = " + total + " <= 0";
                } else if (this.sumMultiplier <= 0.0f) {
                    reason = "sumMultiplier = " + this.sumMultiplier + " <= 0";
                } else if (total / (double)this.sumMultiplier < (double)this.minCostNeedBalance) {
                    reason = "[(cost1*multiplier1)+(cost2*multiplier2)+...+(costn*multipliern)]/sumMultiplier = " + total / (double)this.sumMultiplier + " <= minCostNeedBalance(" + this.minCostNeedBalance + ")";
                }
                this.sendRejectionReasonToRingBuffer(reason, this.costFunctions);
            }
            LOG.info("{} - skipping load balancing because weighted average imbalance={} <= threshold({}). If you want more aggressive balancing, either lower hbase.master.balancer.stochastic.minCostNeedBalance from {} or increase the relative multiplier(s) of the specific cost function(s). functionCost={}", new Object[]{this.isByTable ? "Table specific (" + tableName + ")" : "Cluster wide", total / (double)this.sumMultiplier, Float.valueOf(this.minCostNeedBalance), Float.valueOf(this.minCostNeedBalance), this.functionCost()});
        } else {
            LOG.info("{} - Calculating plan. may take up to {}ms to complete.", (Object)(this.isByTable ? "Table specific (" + tableName + ")" : "Cluster wide"), (Object)this.maxRunningTime);
        }
        return !balanced;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    Pair<CandidateGenerator, BalanceAction> nextAction(BalancerClusterState cluster) {
        CandidateGenerator generator = this.getRandomGenerator();
        return Pair.newPair((Object)generator, (Object)generator.generate(cluster));
    }

    protected CandidateGenerator getRandomGenerator() {
        int i;
        Preconditions.checkState((!this.candidateGenerators.isEmpty() ? 1 : 0) != 0, (Object)"No candidate generators available.");
        List<Class<? extends CandidateGenerator>> generatorClasses = this.shuffledGeneratorClasses.get();
        ArrayList<Double> partialSums = new ArrayList<Double>(generatorClasses.size());
        double sum = 0.0;
        for (Class<? extends CandidateGenerator> clazz : generatorClasses) {
            double weight = this.weightsOfGenerators.getOrDefault(clazz, 0.0);
            partialSums.add(sum += weight);
        }
        if (sum == 0.0) {
            return this.pickAnyGenerator(generatorClasses);
        }
        double rand = ThreadLocalRandom.current().nextDouble();
        for (i = 0; i < partialSums.size(); ++i) {
            partialSums.set(i, (Double)partialSums.get(i) / sum);
        }
        for (i = 0; i < partialSums.size(); ++i) {
            if (!(rand <= (Double)partialSums.get(i))) continue;
            return this.candidateGenerators.get(generatorClasses.get(i));
        }
        return this.pickAnyGenerator(generatorClasses);
    }

    private CandidateGenerator pickAnyGenerator(List<Class<? extends CandidateGenerator>> generatorClasses) {
        Class<? extends CandidateGenerator> randomClass = generatorClasses.get(ThreadLocalRandom.current().nextInt(this.candidateGenerators.size()));
        return this.candidateGenerators.get(randomClass);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    void setRackManager(RackManager rackManager) {
        this.rackManager = rackManager;
    }

    private long calculateMaxSteps(BalancerClusterState cluster) {
        return (long)cluster.numRegions * (long)this.stepsPerRegion * (long)cluster.numServers;
    }

    @Override
    protected List<RegionPlan> balanceTable(TableName tableName, Map<ServerName, List<RegionInfo>> loadOfOneTable) {
        long step;
        long computedMaxSteps;
        double currentCost;
        List<RegionPlan> plans = this.balanceMasterRegions(loadOfOneTable);
        if (plans != null || loadOfOneTable == null || loadOfOneTable.size() <= 1) {
            return plans;
        }
        if (this.masterServerName != null && loadOfOneTable.containsKey(this.masterServerName)) {
            if (loadOfOneTable.size() <= 2) {
                return null;
            }
            loadOfOneTable = new HashMap<ServerName, List<RegionInfo>>(loadOfOneTable);
            loadOfOneTable.remove(this.masterServerName);
        }
        RegionLocationFinder finder = null;
        if (this.localityCost != null && this.localityCost.getMultiplier() > 0.0f || this.rackLocalityCost != null && this.rackLocalityCost.getMultiplier() > 0.0f) {
            finder = this.regionFinder;
        }
        BalancerClusterState cluster = new BalancerClusterState(loadOfOneTable, this.loads, finder, this.rackManager, this.regionCacheRatioOnOldServerMap);
        long startTime = EnvironmentEdgeManager.currentTime();
        this.initCosts(cluster);
        float localSumMultiplier = 0.0f;
        for (CostFunction c : this.costFunctions) {
            if (!c.isNeeded()) continue;
            localSumMultiplier += c.getMultiplier();
        }
        this.sumMultiplier = localSumMultiplier;
        if (this.sumMultiplier <= 0.0f) {
            LOG.error("At least one cost function needs a multiplier > 0. For example, set hbase.master.balancer.stochastic.regionCountCost to a positive value or default");
            return null;
        }
        this.curOverallCost = currentCost = this.computeCost(cluster, Double.MAX_VALUE);
        System.arraycopy(this.tempFunctionCosts, 0, this.curFunctionCosts, 0, this.curFunctionCosts.length);
        this.updateStochasticCosts(tableName, this.curOverallCost, this.curFunctionCosts);
        double initCost = currentCost;
        if (!this.needsBalance(tableName, cluster)) {
            return null;
        }
        if (this.runMaxSteps) {
            computedMaxSteps = Math.max((long)this.maxSteps, this.calculateMaxSteps(cluster));
        } else {
            long calculatedMaxSteps = this.calculateMaxSteps(cluster);
            computedMaxSteps = Math.min((long)this.maxSteps, calculatedMaxSteps);
            if (calculatedMaxSteps > (long)this.maxSteps) {
                LOG.warn("calculatedMaxSteps:{} for loadbalancer's stochastic walk is larger than maxSteps:{}. Hence load balancing may not work well. Setting parameter \"hbase.master.balancer.stochastic.runMaxSteps\" to true can overcome this issue.(This config change does not require service restart)", (Object)calculatedMaxSteps, (Object)this.maxSteps);
            }
        }
        LOG.info("Start StochasticLoadBalancer.balancer, initial weighted average imbalance={}, functionCost={} computedMaxSteps={}", new Object[]{currentCost / (double)this.sumMultiplier, this.functionCost(), computedMaxSteps});
        String initFunctionTotalCosts = this.totalCostsPerFunc();
        HashMap<Class, Long> generatorToStepCount = new HashMap<Class, Long>();
        HashMap generatorToApprovedActionCount = new HashMap();
        for (step = 0L; step < computedMaxSteps; ++step) {
            Pair<CandidateGenerator, BalanceAction> nextAction = this.nextAction(cluster);
            CandidateGenerator generator2 = (CandidateGenerator)nextAction.getFirst();
            BalanceAction action = (BalanceAction)nextAction.getSecond();
            if (action.getType() == BalanceAction.Type.NULL) continue;
            cluster.doAction(action);
            this.updateCostsAndWeightsWithAction(cluster, action);
            generatorToStepCount.merge(generator2.getClass(), 1L, Long::sum);
            double newCost = this.computeCost(cluster, currentCost);
            if (newCost < currentCost) {
                currentCost = newCost;
                generatorToApprovedActionCount.merge(generator2.getClass(), 1L, Long::sum);
                this.curOverallCost = currentCost;
                System.arraycopy(this.tempFunctionCosts, 0, this.curFunctionCosts, 0, this.curFunctionCosts.length);
            } else {
                BalanceAction undoAction = action.undoAction();
                cluster.doAction(undoAction);
                this.updateCostsAndWeightsWithAction(cluster, undoAction);
            }
            if (EnvironmentEdgeManager.currentTime() - startTime > this.maxRunningTime) break;
        }
        long endTime = EnvironmentEdgeManager.currentTime();
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("CandidateGenerator activity summary:");
        generatorToStepCount.forEach((generator, count) -> {
            long approvals = generatorToApprovedActionCount.getOrDefault(generator, 0L);
            joiner.add(String.format(" - %s: %d steps, %d approvals", generator.getSimpleName(), count, approvals));
        });
        LOG.debug(joiner.toString());
        this.metricsBalancer.balanceCluster(endTime - startTime);
        if (initCost > currentCost) {
            this.updateStochasticCosts(tableName, this.curOverallCost, this.curFunctionCosts);
            plans = this.createRegionPlans(cluster);
            LOG.info("Finished computing new moving plan. Computation took {} ms to try {} different iterations.  Found a solution that moves {} regions; Going from a computed imbalance of {} to a new imbalance of {}. funtionCost={}", new Object[]{endTime - startTime, step, plans.size(), initCost / (double)this.sumMultiplier, currentCost / (double)this.sumMultiplier, this.functionCost()});
            this.sendRegionPlansToRingBuffer(plans, currentCost, initCost, initFunctionTotalCosts, step);
            return plans;
        }
        LOG.info("Could not find a better moving plan.  Tried {} different configurations in {} ms, and did not find anything with an imbalance score less than {}", new Object[]{step, endTime - startTime, initCost / (double)this.sumMultiplier});
        return null;
    }

    private void sendRejectionReasonToRingBuffer(String reason, List<CostFunction> costFunctions) {
        if (this.isBalancerRejectionRecording) {
            BalancerRejection.Builder builder = new BalancerRejection.Builder().setReason(reason);
            if (costFunctions != null) {
                for (CostFunction c : costFunctions) {
                    if (!c.isNeeded()) continue;
                    builder.addCostFuncInfo(c.getClass().getName(), c.cost(), c.getMultiplier());
                }
            }
            this.namedQueueRecorder.addRecord(new BalancerRejectionDetails(builder.build()));
        }
    }

    private void sendRegionPlansToRingBuffer(List<RegionPlan> plans, double currentCost, double initCost, String initFunctionTotalCosts, long step) {
        if (this.isBalancerDecisionRecording) {
            ArrayList<String> regionPlans = new ArrayList<String>();
            for (RegionPlan plan : plans) {
                regionPlans.add("table: " + plan.getRegionInfo().getTable() + " , region: " + plan.getRegionName() + " , source: " + plan.getSource() + " , destination: " + plan.getDestination());
            }
            BalancerDecision balancerDecision = new BalancerDecision.Builder().setInitTotalCost(initCost).setInitialFunctionCosts(initFunctionTotalCosts).setComputedTotalCost(currentCost).setFinalFunctionCosts(this.totalCostsPerFunc()).setComputedSteps(step).setRegionPlans(regionPlans).build();
            this.namedQueueRecorder.addRecord(new BalancerDecisionDetails(balancerDecision));
        }
    }

    private void updateStochasticCosts(TableName tableName, double overall, double[] subCosts) {
        if (tableName == null) {
            return;
        }
        if (this.metricsBalancer instanceof MetricsStochasticBalancer) {
            MetricsStochasticBalancer balancer = (MetricsStochasticBalancer)this.metricsBalancer;
            balancer.updateStochasticCost(tableName.getNameAsString(), OVERALL_COST_FUNCTION_NAME, "Overall cost", overall);
            for (int i = 0; i < this.costFunctions.size(); ++i) {
                CostFunction costFunction = this.costFunctions.get(i);
                String costFunctionName = costFunction.getClass().getSimpleName();
                double costPercent = overall == 0.0 ? 0.0 : subCosts[i] / overall;
                balancer.updateStochasticCost(tableName.getNameAsString(), costFunctionName, "The percent of " + costFunctionName, costPercent);
            }
        }
    }

    private void addCostFunction(List<CostFunction> costFunctions, CostFunction costFunction) {
        float multiplier = costFunction.getMultiplier();
        if (multiplier > 0.0f) {
            costFunctions.add(costFunction);
        }
    }

    protected String functionCost() {
        StringBuilder builder = new StringBuilder();
        for (CostFunction c : this.costFunctions) {
            builder.append(c.getClass().getSimpleName());
            builder.append(" : (");
            if (c.isNeeded()) {
                builder.append("multiplier=" + c.getMultiplier());
                builder.append(", ");
                double cost = c.cost();
                builder.append("imbalance=" + cost);
                if (cost >= (double)this.minCostNeedBalance) {
                    builder.append(", need balance");
                }
            } else {
                builder.append("not needed");
            }
            builder.append("); ");
        }
        return builder.toString();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    List<CostFunction> getCostFunctions() {
        return this.costFunctions;
    }

    private String totalCostsPerFunc() {
        StringBuilder builder = new StringBuilder();
        for (CostFunction c : this.costFunctions) {
            double cost;
            if (!c.isNeeded() || !((cost = (double)c.getMultiplier() * c.cost()) > 0.0)) continue;
            builder.append(" ");
            builder.append(c.getClass().getSimpleName());
            builder.append(" : ");
            builder.append(cost);
            builder.append(";");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private List<RegionPlan> createRegionPlans(BalancerClusterState cluster) {
        ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
        for (int regionIndex = 0; regionIndex < cluster.regionIndexToServerIndex.length; ++regionIndex) {
            int initialServerIndex = cluster.initialRegionIndexToServerIndex[regionIndex];
            int newServerIndex = cluster.regionIndexToServerIndex[regionIndex];
            if (initialServerIndex == newServerIndex) continue;
            RegionInfo region = cluster.regions[regionIndex];
            ServerName initialServer = cluster.servers[initialServerIndex];
            ServerName newServer = cluster.servers[newServerIndex];
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving Region " + region.getEncodedName() + " from server " + initialServer.getHostname() + " to " + newServer.getHostname());
            }
            RegionPlan rp = new RegionPlan(region, initialServer, newServer);
            plans.add(rp);
        }
        return plans;
    }

    private void updateRegionLoad() {
        Map<String, Deque<BalancerRegionLoad>> oldLoads = this.loads;
        this.loads = new HashMap<String, Deque<BalancerRegionLoad>>();
        this.clusterStatus.getLiveServerMetrics().forEach((sn, sm) -> sm.getRegionMetrics().forEach((regionName, rm) -> {
            String regionNameAsString = RegionInfo.getRegionNameAsString((byte[])regionName);
            ArrayDeque<BalancerRegionLoad> rLoads = (ArrayDeque<BalancerRegionLoad>)oldLoads.get(regionNameAsString);
            if (rLoads == null) {
                rLoads = new ArrayDeque<BalancerRegionLoad>(this.numRegionLoadsToRemember + 1);
            } else if (rLoads.size() >= this.numRegionLoadsToRemember) {
                rLoads.remove();
            }
            rLoads.add(new BalancerRegionLoad((RegionMetrics)rm));
            this.loads.put(regionNameAsString, rLoads);
        }));
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    void initCosts(BalancerClusterState cluster) {
        this.weightsOfGenerators.clear();
        for (Class<? extends CandidateGenerator> clazz : this.candidateGenerators.keySet()) {
            this.weightsOfGenerators.put(clazz, 0.0);
        }
        for (CostFunction c : this.costFunctions) {
            c.prepare(cluster);
            c.updateWeight(this.weightsOfGenerators);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    void updateCostsAndWeightsWithAction(BalancerClusterState cluster, BalanceAction action) {
        for (Class<? extends CandidateGenerator> clazz : this.candidateGenerators.keySet()) {
            this.weightsOfGenerators.put(clazz, 0.0);
        }
        for (CostFunction c : this.costFunctions) {
            if (!c.isNeeded()) continue;
            c.postAction(action);
            c.updateWeight(this.weightsOfGenerators);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    String[] getCostFunctionNames() {
        String[] ret = new String[this.costFunctions.size()];
        for (int i = 0; i < this.costFunctions.size(); ++i) {
            CostFunction c = this.costFunctions.get(i);
            ret[i] = c.getClass().getSimpleName();
        }
        return ret;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    double computeCost(BalancerClusterState cluster, double previousCost) {
        double total = 0.0;
        for (int i = 0; i < this.costFunctions.size(); ++i) {
            CostFunction c = this.costFunctions.get(i);
            this.tempFunctionCosts[i] = 0.0;
            if (!c.isNeeded()) continue;
            Float multiplier = Float.valueOf(c.getMultiplier());
            double cost = c.cost();
            this.tempFunctionCosts[i] = (double)multiplier.floatValue() * cost;
            if ((total += this.tempFunctionCosts[i]) > previousCost) break;
        }
        return total;
    }

    static String composeAttributeName(String tableName, String costFunctionName) {
        return tableName + TABLE_FUNCTION_SEP + costFunctionName;
    }

    public static enum GeneratorType {
        RANDOM,
        LOAD,
        LOCALITY,
        RACK;

    }
}

