/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.bulkdatagenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.bulkdatagenerator.BulkDataGeneratorInputFormat;
import org.apache.hadoop.hbase.util.bulkdatagenerator.BulkDataGeneratorMapper;
import org.apache.hadoop.hbase.util.bulkdatagenerator.BulkDataGeneratorRecordReader;
import org.apache.hadoop.hbase.util.bulkdatagenerator.Utility;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.GnuParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkDataGeneratorTool {
    private static final Logger logger = LoggerFactory.getLogger(BulkDataGeneratorTool.class);
    private static final String OUTPUT_DIRECTORY_PREFIX = "/bulk_data_generator/";
    private int mapperCount;
    private long rowsPerMapper;
    private String table;
    private int splitCount;
    private boolean deleteTableIfExist;
    private final Map<String, String> tableOptions = new HashMap<String, String>();

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        BulkDataGeneratorTool bulkDataGeneratorTool = new BulkDataGeneratorTool();
        bulkDataGeneratorTool.run(conf, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean run(Configuration conf, String[] args) throws IOException {
        CommandLine line = null;
        try {
            GnuParser parser = new GnuParser();
            line = parser.parse(this.getOptions(), args);
            this.readCommandLineParameters(conf, line);
        }
        catch (IOException | ParseException exception) {
            logger.error("Error while parsing CLI arguments.", exception);
            this.printUsage();
            return false;
        }
        if (line.hasOption("-h")) {
            this.printUsage();
            return true;
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.table) ? 1 : 0) != 0, (Object)"Table name must not be empty");
        Preconditions.checkArgument((this.mapperCount > 0 ? 1 : 0) != 0, (Object)"Mapper count must be greater than 0");
        Preconditions.checkArgument((this.splitCount > 0 && this.splitCount < Utility.MAX_SPLIT_COUNT ? 1 : 0) != 0, (Object)("Split count must be greater than 0 and less than " + Utility.MAX_SPLIT_COUNT));
        Preconditions.checkArgument((this.rowsPerMapper > 0L ? 1 : 0) != 0, (Object)"Rows per mapper must be greater than 0");
        Path outputDirectory = this.generateOutputDirectory();
        logger.info("HFiles will be generated at " + outputDirectory.toString());
        try {
            boolean bl;
            Throwable throwable;
            Connection connection;
            block35: {
                block36: {
                    block32: {
                        boolean bl2;
                        block33: {
                            block34: {
                                TableName tableName;
                                Admin admin;
                                block29: {
                                    boolean bl3;
                                    block30: {
                                        block31: {
                                            connection = ConnectionFactory.createConnection((Configuration)conf);
                                            throwable = null;
                                            admin = connection.getAdmin();
                                            tableName = TableName.valueOf((String)this.table);
                                            if (!admin.tableExists(tableName)) break block29;
                                            if (this.deleteTableIfExist) {
                                                logger.info("Deleting the table since it already exist and delete-if-exist flag is set to true");
                                                Utility.deleteTable(admin, this.table);
                                                break block29;
                                            }
                                            logger.info("Table already exists, cannot generate HFiles for existing table.");
                                            bl3 = false;
                                            if (connection == null) break block30;
                                            if (throwable == null) break block31;
                                            try {
                                                connection.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block30;
                                        }
                                        connection.close();
                                    }
                                    return bl3;
                                }
                                Utility.createTable(admin, this.table, this.splitCount, this.tableOptions);
                                logger.info(this.table + " created successfully");
                                Job job = this.createSubmittableJob(conf);
                                Table hbaseTable = connection.getTable(tableName);
                                HFileOutputFormat2.configureIncrementalLoad((Job)job, (Table)hbaseTable, (RegionLocator)hbaseTable.getRegionLocator());
                                FileOutputFormat.setOutputPath((Job)job, (Path)outputDirectory);
                                boolean result = job.waitForCompletion(true);
                                if (!result) break block32;
                                logger.info("HFiles generated successfully. Starting bulk load to " + this.table);
                                BulkLoadHFilesTool bulkLoadHFilesTool = new BulkLoadHFilesTool(conf);
                                Map bulkLoadedHFiles = bulkLoadHFilesTool.bulkLoad(tableName, outputDirectory);
                                boolean status = !bulkLoadedHFiles.isEmpty();
                                logger.info("BulkLoadHFiles finished successfully with status " + status);
                                bl2 = status;
                                if (connection == null) break block33;
                                if (throwable == null) break block34;
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block33;
                            }
                            connection.close();
                        }
                        return bl2;
                    }
                    logger.info("Failed to generate HFiles.");
                    bl = false;
                    if (connection == null) break block35;
                    if (throwable == null) break block36;
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block35;
                }
                connection.close();
            }
            return bl;
            catch (Throwable throwable5) {
                try {
                    try {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (connection != null) {
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                connection.close();
                            }
                        }
                        throw throwable6;
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to generate data", (Throwable)e);
                    boolean bl4 = false;
                    return bl4;
                }
            }
        }
        finally {
            FileSystem.get((Configuration)conf).deleteOnExit(outputDirectory);
        }
    }

    protected Job createSubmittableJob(Configuration conf) throws IOException {
        conf.setInt(BulkDataGeneratorMapper.SPLIT_COUNT_KEY, this.splitCount);
        conf.setInt(BulkDataGeneratorInputFormat.MAPPER_TASK_COUNT_KEY, this.mapperCount);
        conf.setLong(BulkDataGeneratorRecordReader.RECORDS_PER_MAPPER_TASK_KEY, this.rowsPerMapper);
        Job job = new Job(conf, BulkDataGeneratorTool.class.getSimpleName() + " - " + this.table);
        job.setJarByClass(BulkDataGeneratorMapper.class);
        job.setInputFormatClass(BulkDataGeneratorInputFormat.class);
        HBaseConfiguration.addHbaseResources((Configuration)conf);
        job.setMapperClass(BulkDataGeneratorMapper.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
        return job;
    }

    protected Path generateOutputDirectory() {
        String outputDirectory = "/bulk_data_generator//" + this.table + "-" + System.currentTimeMillis();
        return new Path(outputDirectory);
    }

    protected void readCommandLineParameters(Configuration conf, CommandLine line) throws ParseException, IOException {
        ArrayList<String> genericParameters = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : line.getOptionProperties("D").entrySet()) {
            genericParameters.add("-D");
            genericParameters.add(entry.getKey() + "=" + entry.getValue());
        }
        logger.info("Parsed generic parameters: " + Arrays.toString(genericParameters.toArray(new String[0])));
        new GenericOptionsParser(conf, genericParameters.toArray(new String[0]));
        this.table = line.getOptionValue("table");
        if (line.hasOption("mapper-count")) {
            this.mapperCount = Integer.parseInt(line.getOptionValue("mapper-count"));
        }
        if (line.hasOption("split-count")) {
            this.splitCount = Integer.parseInt(line.getOptionValue("split-count"));
        }
        if (line.hasOption("rows-per-mapper")) {
            this.rowsPerMapper = Long.parseLong(line.getOptionValue("rows-per-mapper"));
        }
        this.deleteTableIfExist = line.hasOption("delete-if-exist");
        this.parseTableOptions(line);
    }

    private void parseTableOptions(CommandLine line) {
        String tableOptionsAsString = line.getOptionValue("table-options");
        if (!StringUtils.isEmpty((CharSequence)tableOptionsAsString)) {
            for (String tableOption : tableOptionsAsString.split(",")) {
                String[] keyValueSplit = tableOption.split("=");
                String key = keyValueSplit[0];
                String value = keyValueSplit[1];
                this.tableOptions.put(key, value);
            }
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        Option option = new Option("t", "table", true, "The table name for which data need to be generated.");
        options.addOption(option);
        option = new Option("d", "delete-if-exist", false, "If it's set, the table will be deleted if already exist.");
        options.addOption(option);
        option = new Option("mc", "mapper-count", true, "The number of mapper containers to be launched.");
        options.addOption(option);
        option = new Option("sc", "split-count", true, "The number of regions/pre-splits to be created for the table.");
        options.addOption(option);
        option = new Option("r", "rows-per-mapper", true, "The number of rows to be generated PER mapper.");
        options.addOption(option);
        option = new Option("o", "table-options", true, "Table options to be set while creating the table.");
        options.addOption(option);
        option = new Option("h", "help", false, "Show help message for the tool");
        options.addOption(option);
        return options;
    }

    protected void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(120);
        String helpMessageCommand = "hbase " + BulkDataGeneratorTool.class.getName();
        String commandSyntax = helpMessageCommand + " <OPTIONS> [-D<property=value>]*";
        String helpMessageSuffix = "Examples:\n" + helpMessageCommand + " -t TEST_TABLE -mc 10 -r 100 -sc 10\n" + helpMessageCommand + " -t TEST_TABLE -mc 10 -r 100 -sc 10 -d -o \"BACKUP=false,NORMALIZATION_ENABLED=false\"\n" + helpMessageCommand + " -t TEST_TABLE -mc 10 -r 100 -sc 10 -Dmapreduce.map.memory.mb=8192\n";
        helpFormatter.printHelp(commandSyntax, "", this.getOptions(), helpMessageSuffix);
    }
}

