/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.MultiThreadedAction;

public class LoadTestDataGeneratorWithMOB
extends MultiThreadedAction.DefaultDataGenerator {
    private byte[] mobColumnFamily;
    private LoadTestKVGenerator mobKvGenerator;

    public LoadTestDataGeneratorWithMOB(int minValueSize, int maxValueSize, int minColumnsPerKey, int maxColumnsPerKey, byte[] ... columnFamilies) {
        super(minValueSize, maxValueSize, minColumnsPerKey, maxColumnsPerKey, columnFamilies);
    }

    public LoadTestDataGeneratorWithMOB(byte[] ... columnFamilies) {
        super(columnFamilies);
    }

    @Override
    public void initialize(String[] args) {
        super.initialize(args);
        if (args.length != 3) {
            throw new IllegalArgumentException("LoadTestDataGeneratorWithMOB can have 3 arguments.1st argument is a column family, the 2nd argument is the minimum mob data size and the 3rd argument is the maximum mob data size.");
        }
        String mobColumnFamily = args[0];
        int minMobDataSize = Integer.parseInt(args[1]);
        int maxMobDataSize = Integer.parseInt(args[2]);
        this.configureMob(Bytes.toBytes((String)mobColumnFamily), minMobDataSize, maxMobDataSize);
    }

    private void configureMob(byte[] mobColumnFamily, int minMobDataSize, int maxMobDataSize) {
        this.mobColumnFamily = mobColumnFamily;
        this.mobKvGenerator = new LoadTestKVGenerator(minMobDataSize, maxMobDataSize);
    }

    @Override
    public byte[] generateValue(byte[] rowKey, byte[] cf, byte[] column) {
        if (Arrays.equals(cf, this.mobColumnFamily)) {
            return this.mobKvGenerator.generateRandomSizeValue((byte[][])new byte[][]{rowKey, cf, column});
        }
        return super.generateValue(rowKey, cf, column);
    }
}

