/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.UUID;
import org.apache.hadoop.fs.StorageType;

public class DatanodeStorage {
    private final String storageID;
    private final State state;
    private final StorageType storageType;
    private static final String STORAGE_ID_PREFIX = "DS-";

    public DatanodeStorage(String storageID) {
        this(storageID, State.NORMAL, StorageType.DEFAULT);
    }

    public DatanodeStorage(String sid, State s, StorageType sm) {
        this.storageID = sid;
        this.state = s;
        this.storageType = sm;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public State getState() {
        return this.state;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public static String generateUuid() {
        return STORAGE_ID_PREFIX + UUID.randomUUID();
    }

    public static boolean isValidStorageId(String storageID) {
        try {
            if (storageID != null && storageID.indexOf(STORAGE_ID_PREFIX) == 0) {
                UUID.fromString(storageID.substring(STORAGE_ID_PREFIX.length()));
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "DatanodeStorage[" + this.storageID + "," + (Object)((Object)this.storageType) + "," + (Object)((Object)this.state) + "]";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof DatanodeStorage)) {
            return false;
        }
        DatanodeStorage otherStorage = (DatanodeStorage)other;
        return otherStorage.getStorageID().compareTo(this.getStorageID()) == 0;
    }

    public int hashCode() {
        return this.getStorageID().hashCode();
    }

    public static enum State {
        NORMAL,
        READ_ONLY_SHARED,
        FAILED;

    }
}

