/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleConditionalVariable;

public class VariableContext {
    private Map<String, String> variables = new HashMap<String, String>();
    private Map<String, String> originalVariables = new HashMap<String, String>();
    private Map<String, MappingRuleConditionalVariable> conditionalVariables = new HashMap<String, MappingRuleConditionalVariable>();
    private Set<String> immutableNames;
    private Map<String, Set<String>> extraDataset = new HashMap<String, Set<String>>();

    public boolean isImmutable(String name) {
        return this.immutableNames != null && this.immutableNames.contains(name);
    }

    public VariableContext setImmutables(Set<String> variableNames) {
        if (this.immutableNames != null) {
            throw new IllegalStateException("Immutable variables are already defined, variable immutability cannot be changed once set!");
        }
        this.immutableNames = ImmutableSet.copyOf(variableNames);
        return this;
    }

    public VariableContext setImmutables(String ... variableNames) {
        if (this.immutableNames != null) {
            throw new IllegalStateException("Immutable variables are already defined, variable immutability cannot be changed once set!");
        }
        this.immutableNames = ImmutableSet.copyOf((Object[])variableNames);
        return this;
    }

    public VariableContext put(String name, String value) {
        if (this.variables.containsKey(name) && this.isImmutable(name)) {
            throw new IllegalStateException("Variable '" + name + "' is immutable, cannot update it's value!");
        }
        if (this.conditionalVariables.containsKey(name)) {
            throw new IllegalStateException("Variable '" + name + "' is already defined as a conditional variable, cannot change it's value!");
        }
        this.variables.put(name, value);
        return this;
    }

    public void putOriginal(String name, String value) {
        this.originalVariables.put(name, value);
    }

    public VariableContext putConditional(String name, MappingRuleConditionalVariable variable) {
        if (this.conditionalVariables.containsKey(name)) {
            throw new IllegalStateException("Variable '" + name + "' is conditional, cannot update it's value!");
        }
        this.conditionalVariables.put(name, variable);
        return this;
    }

    public String get(String name) {
        String ret = this.variables.get(name);
        return ret == null ? "" : ret;
    }

    public String getOriginal(String name) {
        return this.originalVariables.get(name);
    }

    public void putExtraDataset(String name, Set<String> set) {
        if (this.extraDataset.containsKey(name)) {
            throw new IllegalStateException("Dataset '" + name + "' is already set!");
        }
        this.extraDataset.put(name, set);
    }

    public Set<String> getExtraDataset(String name) {
        return this.extraDataset.get(name);
    }

    public boolean containsKey(String name) {
        return this.variables.containsKey(name);
    }

    public String replaceVariables(String input) {
        if (input == null) {
            return null;
        }
        String[] keys = this.variables.keySet().toArray(new String[0]);
        Arrays.sort(keys, (a, b) -> b.length() - a.length());
        String ret = input;
        for (String key : keys) {
            if (key == null) continue;
            ret = ret.replace(key, this.get(key));
        }
        return ret;
    }

    public String replacePathVariables(String input) {
        if (input == null) {
            return null;
        }
        CharSequence[] parts = input.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            MappingRuleConditionalVariable condVariable;
            String newVal = parts[i];
            if (this.variables.containsKey(parts[i])) {
                newVal = this.variables.get(parts[i]);
            } else if (this.conditionalVariables.containsKey(parts[i]) && (condVariable = this.conditionalVariables.get(parts[i])) != null) {
                newVal = condVariable.evaluateInPath((String[])parts, i);
            }
            if (newVal == null) {
                newVal = "";
            }
            parts[i] = newVal;
        }
        return String.join((CharSequence)".", parts);
    }
}

