/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router;

import java.net.InetAddress;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouterAuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAuditLogger.class);

    private RouterAuditLogger() {
    }

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createSuccessLog(user, operation, target, null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createSuccessLog(user, operation, target, appId, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, SubClusterId subClusterId) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createSuccessLog(user, operation, target, appId, subClusterId));
        }
    }

    static String createSuccessLog(String user, String operation, String target, ApplicationId appId, SubClusterId subClusterID) {
        StringBuilder b = RouterAuditLogger.createStringBuilderForSuccessEvent(user, operation, target);
        if (appId != null) {
            RouterAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (subClusterID != null) {
            RouterAuditLogger.add(Keys.SUBCLUSTERID, subClusterID.toString(), b);
        }
        return b.toString();
    }

    private static StringBuilder createStringBuilderForSuccessEvent(String user, String operation, String target) {
        StringBuilder b = new StringBuilder();
        RouterAuditLogger.start(Keys.USER, user, b);
        RouterAuditLogger.addRemoteIP(b);
        RouterAuditLogger.add(Keys.OPERATION, operation, b);
        RouterAuditLogger.add(Keys.TARGET, target, b);
        RouterAuditLogger.add(Keys.RESULT, "SUCCESS", b);
        return b;
    }

    public static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createFailureLog(user, operation, perm, target, description, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String descriptionFormat, Object ... args) {
        if (LOG.isInfoEnabled()) {
            String description = String.format(descriptionFormat, args);
            LOG.info(RouterAuditLogger.createFailureLog(user, operation, perm, target, description, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, SubClusterId subClusterId) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createFailureLog(user, operation, perm, target, description, appId, subClusterId));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, SubClusterId subClusterId) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RouterAuditLogger.createFailureLog(user, operation, perm, target, description, null, subClusterId));
        }
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description, ApplicationId appId, SubClusterId subClusterId) {
        StringBuilder b = RouterAuditLogger.createStringBuilderForFailureLog(user, operation, target, description, perm);
        if (appId != null) {
            RouterAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (subClusterId != null) {
            RouterAuditLogger.add(Keys.SUBCLUSTERID, subClusterId.toString(), b);
        }
        return b.toString();
    }

    private static StringBuilder createStringBuilderForFailureLog(String user, String operation, String target, String description, String perm) {
        StringBuilder b = new StringBuilder();
        RouterAuditLogger.start(Keys.USER, user, b);
        RouterAuditLogger.addRemoteIP(b);
        RouterAuditLogger.add(Keys.OPERATION, operation, b);
        RouterAuditLogger.add(Keys.TARGET, target, b);
        RouterAuditLogger.add(Keys.RESULT, "FAILURE", b);
        RouterAuditLogger.add(Keys.DESCRIPTION, description, b);
        RouterAuditLogger.add(Keys.PERMISSIONS, perm, b);
        return b;
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            RouterAuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
    }

    public static class AuditConstants {
        static final String SUCCESS = "SUCCESS";
        static final String FAILURE = "FAILURE";
        static final String KEY_VAL_SEPARATOR = "=";
        static final char PAIR_SEPARATOR = '\t';
        public static final String GET_NEW_APP = "Get New App";
        public static final String SUBMIT_NEW_APP = "Submit New App";
        public static final String FORCE_KILL_APP = "Force Kill App";
        public static final String GET_APP_REPORT = "Get Application Report";
        public static final String TARGET_CLIENT_RM_SERVICE = "RouterClientRMService";
        public static final String TARGET_WEB_SERVICE = "RouterWebServices";
        public static final String UNKNOWN = "UNKNOWN";
        public static final String GET_APPLICATIONS = "Get Applications";
        public static final String GET_CLUSTERMETRICS = "Get ClusterMetrics";
        public static final String GET_CLUSTERNODES = "Get ClusterNodes";
        public static final String GET_QUEUEINFO = "Get QueueInfo";
        public static final String GET_QUEUE_USER_ACLS = "Get QueueUserAcls";
        public static final String MOVE_APPLICATION_ACROSS_QUEUES = "Move ApplicationAcrossQueues";
        public static final String GET_NEW_RESERVATION = "Get NewReservation";
        public static final String SUBMIT_RESERVATION = "Submit Reservation";
        public static final String LIST_RESERVATIONS = "List Reservations";
        public static final String UPDATE_RESERVATION = "Update Reservation";
        public static final String DELETE_RESERVATION = "Delete Reservation";
        public static final String GET_NODETOLABELS = "Get NodeToLabels";
        public static final String GET_LABELSTONODES = "Get LabelsToNodes";
        public static final String GET_CLUSTERNODELABELS = "Get ClusterNodeLabels";
        public static final String GET_APPLICATION_ATTEMPT_REPORT = "Get ApplicationAttemptReport";
        public static final String GET_APPLICATION_ATTEMPTS = "Get ApplicationAttempts";
        public static final String GET_CONTAINERREPORT = "Get ContainerReport";
        public static final String GET_CONTAINERS = "Get Containers";
        public static final String GET_DELEGATIONTOKEN = "Get DelegationToken";
        public static final String RENEW_DELEGATIONTOKEN = "Renew DelegationToken";
        public static final String CANCEL_DELEGATIONTOKEN = "Cancel DelegationToken";
        public static final String FAIL_APPLICATIONATTEMPT = "Fail ApplicationAttempt";
        public static final String UPDATE_APPLICATIONPRIORITY = "Update ApplicationPriority";
        public static final String SIGNAL_TOCONTAINER = "Signal ToContainer";
        public static final String UPDATE_APPLICATIONTIMEOUTS = "Update ApplicationTimeouts";
        public static final String GET_RESOURCEPROFILES = "Get ResourceProfiles";
        public static final String GET_RESOURCEPROFILE = "Get ResourceProfile";
        public static final String GET_RESOURCETYPEINFO = "Get ResourceTypeInfo";
        public static final String GET_ATTRIBUTESTONODES = "Get AttributesToNodes";
        public static final String GET_CLUSTERNODEATTRIBUTES = "Get ClusterNodeAttributes";
        public static final String GET_NODESTOATTRIBUTES = "Get NodesToAttributes";
        public static final String GET_CLUSTERINFO = "Get ClusterInfo";
        public static final String GET_CLUSTERUSERINFO = "Get ClusterUserInfo";
        public static final String GET_SCHEDULERINFO = "Get SchedulerInfo";
        public static final String DUMP_SCHEDULERLOGS = "Dump SchedulerLogs";
        public static final String GET_ACTIVITIES = "Get Activities";
        public static final String GET_BULKACTIVITIES = "Get BulkActivities";
        public static final String GET_APPACTIVITIES = "Get AppActivities";
        public static final String GET_APPSTATISTICS = "Get AppStatistics";
        public static final String GET_RMNODELABELS = "Get RMNodeLabels";
        public static final String REPLACE_LABELSONNODES = "Replace LabelsOnNodes";
        public static final String REPLACE_LABELSONNODE = "Replace LabelsOnNode";
        public static final String GET_CLUSTER_NODELABELS = "Get ClusterNodeLabels";
        public static final String ADD_TO_CLUSTER_NODELABELS = "Add To ClusterNodeLabels";
        public static final String REMOVE_FROM_CLUSTERNODELABELS = "Remove From ClusterNodeLabels";
        public static final String GET_LABELS_ON_NODE = "Get LabelsOnNode";
        public static final String GET_APP_PRIORITY = "Get AppPriority";
        public static final String UPDATE_APP_QUEUE = "Update AppQueue";
        public static final String POST_DELEGATION_TOKEN = "Post DelegationToken";
        public static final String POST_DELEGATION_TOKEN_EXPIRATION = "Post DelegationTokenExpiration";
        public static final String GET_APP_TIMEOUT = "Get App Timeout";
        public static final String GET_APP_TIMEOUTS = "Get App Timeouts";
        public static final String CHECK_USER_ACCESS_TO_QUEUE = "Check User AccessToQueue";
        public static final String GET_APP_ATTEMPT = "Get AppAttempt";
        public static final String GET_CONTAINER = "Get Container";
        public static final String UPDATE_SCHEDULER_CONFIGURATION = "Update SchedulerConfiguration";
        public static final String GET_SCHEDULER_CONFIGURATION = "Get SchedulerConfiguration";
    }

    static enum Keys {
        USER,
        OPERATION,
        TARGET,
        RESULT,
        IP,
        PERMISSIONS,
        DESCRIPTION,
        APPID,
        SUBCLUSTERID;

    }
}

