/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ConfigurationProperties;

public final class UserWeights {
    public static final float DEFAULT_WEIGHT = 1.0f;
    private final Map<String, Float> data = new HashMap<String, Float>();

    private UserWeights() {
    }

    public static UserWeights createEmpty() {
        return new UserWeights();
    }

    public static UserWeights createByConfig(CapacitySchedulerConfiguration conf, ConfigurationProperties configurationProperties, String queuePath) {
        String queuePathPlusPrefix = CapacitySchedulerConfiguration.getQueuePrefix(queuePath) + "user-settings";
        Map<String, String> props = configurationProperties.getPropertiesWithPrefix(queuePathPlusPrefix);
        UserWeights userWeights = new UserWeights();
        for (Map.Entry<String, String> item : props.entrySet()) {
            String userName;
            Matcher m = CapacitySchedulerConfiguration.USER_WEIGHT_PATTERN.matcher(item.getKey());
            if (!m.find() || (userName = item.getKey().replaceFirst("\\.weight", "")).isEmpty()) continue;
            String value = conf.substituteCommonVariables(item.getValue());
            userWeights.data.put(userName, new Float(value));
        }
        return userWeights;
    }

    public float getByUser(String userName) {
        Float weight = this.data.get(userName);
        if (weight == null) {
            return 1.0f;
        }
        return weight.floatValue();
    }

    public void validateForLeafQueue(float queueUserLimit, String queuePath) throws IOException {
        for (Map.Entry<String, Float> e : this.data.entrySet()) {
            String userName = e.getKey();
            float weight = e.getValue().floatValue();
            if (!(weight < 0.0f) && !(weight > 100.0f / queueUserLimit)) continue;
            throw new IOException("Weight (" + weight + ") for user \"" + userName + "\" must be between 0 and 100 / " + queueUserLimit + " (= " + 100.0f / queueUserLimit + ", the number of concurrent active users in " + queuePath + ")");
        }
    }

    public void addFrom(UserWeights addFrom) {
        this.data.putAll(addFrom.data);
    }
}

