/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class RotateRight
extends MatrixOperation {
    public static final RotateRight SETUP = new RotateRight();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] aData, int aRowDim, int aColA, int aColB, BigDecimal aCos, BigDecimal aSin) {
        int tmpIndexA = aColA * aRowDim;
        int tmpIndexB = aColB * aRowDim;
        for (int i = 0; i < aRowDim; ++i) {
            BigDecimal tmpOldA = aData[tmpIndexA];
            BigDecimal tmpOldB = aData[tmpIndexB];
            aData[tmpIndexA] = BigFunction.SUBTRACT.invoke(BigFunction.MULTIPLY.invoke(aCos, tmpOldA), BigFunction.MULTIPLY.invoke(aSin, tmpOldB));
            aData[tmpIndexB] = BigFunction.ADD.invoke(BigFunction.MULTIPLY.invoke(aCos, tmpOldB), BigFunction.MULTIPLY.invoke(aSin, tmpOldA));
            ++tmpIndexA;
            ++tmpIndexB;
        }
    }

    public static void invoke(ComplexNumber[] aData, int aRowDim, int aColA, int aColB, ComplexNumber aCos, ComplexNumber aSin) {
        int tmpIndexA = aColA * aRowDim;
        int tmpIndexB = aColB * aRowDim;
        for (int i = 0; i < aRowDim; ++i) {
            ComplexNumber tmpOldA = aData[tmpIndexA];
            ComplexNumber tmpOldB = aData[tmpIndexB];
            aData[tmpIndexA] = aCos.multiply(tmpOldA).subtract(aSin.multiply(tmpOldB));
            aData[tmpIndexB] = aCos.multiply(tmpOldB).add(aSin.multiply(tmpOldA));
            ++tmpIndexA;
            ++tmpIndexB;
        }
    }

    public static void invoke(double[] aData, int aRowDim, int aColA, int aColB, double aCos, double aSin) {
        int tmpIndexA = aColA * aRowDim;
        int tmpIndexB = aColB * aRowDim;
        for (int i = 0; i < aRowDim; ++i) {
            double tmpOldA = aData[tmpIndexA];
            double tmpOldB = aData[tmpIndexB];
            aData[tmpIndexA] = aCos * tmpOldA - aSin * tmpOldB;
            aData[tmpIndexB] = aCos * tmpOldB + aSin * tmpOldA;
            ++tmpIndexA;
            ++tmpIndexB;
        }
    }

    private RotateRight() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

