/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetColumnPrefetchStore;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMappers;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMetadata;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.FileTail;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetParser;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.shaded.apache.parquet.format.ColumnChunk;
import software.amazon.s3.shaded.apache.parquet.format.FileMetaData;
import software.amazon.s3.shaded.apache.parquet.format.RowGroup;

public class ParquetMetadataParsingTask {
    private final S3URI s3URI;
    private final ParquetParser parquetParser;
    private final ParquetColumnPrefetchStore parquetColumnPrefetchStore;
    private static final Logger LOG = LoggerFactory.getLogger(ParquetMetadataParsingTask.class);

    public ParquetMetadataParsingTask(S3URI s3URI, ParquetColumnPrefetchStore parquetColumnPrefetchStore) {
        this(s3URI, parquetColumnPrefetchStore, new ParquetParser());
    }

    ParquetMetadataParsingTask(@NonNull S3URI s3URI, @NonNull ParquetColumnPrefetchStore parquetColumnPrefetchStore, @NonNull ParquetParser parquetParser) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (parquetColumnPrefetchStore == null) {
            throw new NullPointerException("parquetColumnPrefetchStore is marked non-null but is null");
        }
        if (parquetParser == null) {
            throw new NullPointerException("parquetParser is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.parquetParser = parquetParser;
        this.parquetColumnPrefetchStore = parquetColumnPrefetchStore;
    }

    public ColumnMappers storeColumnMappers(FileTail fileTail) {
        try {
            FileMetaData fileMetaData = this.parquetParser.parseParquetFooter(fileTail.getFileTail(), fileTail.getFileTailLength(), this.s3URI);
            ColumnMappers columnMappers = this.buildColumnMaps(fileMetaData);
            this.parquetColumnPrefetchStore.putColumnMappers(this.s3URI, columnMappers);
            return columnMappers;
        }
        catch (Exception e) {
            LOG.debug("Unable to parse parquet footer for {}, parquet prefetch optimisations will be disabled for this key.", (Object)this.s3URI.getKey(), (Object)e);
            throw new CompletionException("Error parsing parquet footer", e);
        }
    }

    private ColumnMappers buildColumnMaps(FileMetaData fileMetaData) {
        HashMap<Long, ColumnMetadata> offsetIndexToColumnMap = new HashMap<Long, ColumnMetadata>();
        HashMap<String, List<ColumnMetadata>> columnNameToColumnMap = new HashMap<String, List<ColumnMetadata>>();
        String concatenatedColumnNames = this.concatColumnNames(fileMetaData);
        int rowGroupIndex = 0;
        for (RowGroup rowGroup : fileMetaData.getRow_groups()) {
            for (ColumnChunk columnChunk : rowGroup.getColumns()) {
                List columnMetadataList;
                ColumnMetadata columnMetadata;
                String columnName = String.join((CharSequence)".", columnChunk.getMeta_data().getPath_in_schema());
                if (columnChunk.getMeta_data().getDictionary_page_offset() != 0L) {
                    columnMetadata = new ColumnMetadata(rowGroupIndex, columnName, columnChunk.getMeta_data().getData_page_offset(), columnChunk.getMeta_data().getDictionary_page_offset(), columnChunk.getMeta_data().getDictionary_page_offset(), columnChunk.getMeta_data().getTotal_compressed_size(), concatenatedColumnNames.hashCode());
                    offsetIndexToColumnMap.put(columnChunk.getMeta_data().getDictionary_page_offset(), columnMetadata);
                    columnMetadataList = columnNameToColumnMap.computeIfAbsent(columnName, metadataList -> new ArrayList());
                    columnMetadataList.add(columnMetadata);
                    continue;
                }
                columnMetadata = new ColumnMetadata(rowGroupIndex, columnName, columnChunk.getMeta_data().getData_page_offset(), 0L, columnChunk.getFile_offset(), columnChunk.getMeta_data().getTotal_compressed_size(), concatenatedColumnNames.hashCode());
                offsetIndexToColumnMap.put(columnChunk.getFile_offset(), columnMetadata);
                columnMetadataList = columnNameToColumnMap.computeIfAbsent(columnName, metadataList -> new ArrayList());
                columnMetadataList.add(columnMetadata);
            }
            ++rowGroupIndex;
        }
        return new ColumnMappers(offsetIndexToColumnMap, columnNameToColumnMap);
    }

    private String concatColumnNames(FileMetaData fileMetaData) {
        StringBuilder concatenatedColumnNames = new StringBuilder();
        RowGroup rowGroup = fileMetaData.getRow_groups().get(0);
        for (ColumnChunk columnChunk : rowGroup.getColumns()) {
            String columnName = String.join((CharSequence)".", columnChunk.getMeta_data().getPath_in_schema());
            concatenatedColumnNames.append(columnName);
        }
        return concatenatedColumnNames.toString();
    }
}

