/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.partition.file.SuccessFile;

public class SuccessFileMarkDoneAction
implements PartitionMarkDoneAction {
    public static final String SUCCESS_FILE_NAME = "_SUCCESS";
    private final FileIO fileIO;
    private final Path tablePath;

    public SuccessFileMarkDoneAction(FileIO fileIO, Path tablePath) {
        this.fileIO = fileIO;
        this.tablePath = tablePath;
    }

    @Override
    public void markDone(String partition) throws Exception {
        Path partitionPath = new Path(this.tablePath, partition);
        Path successPath = new Path(partitionPath, SUCCESS_FILE_NAME);
        long currentTime = System.currentTimeMillis();
        SuccessFile successFile = new SuccessFile(currentTime, currentTime);
        if (this.fileIO.exists(successPath)) {
            successFile = SuccessFile.fromPath(this.fileIO, successPath).updateModificationTime(currentTime);
        }
        this.fileIO.overwriteFileUtf8(successPath, successFile.toJson());
    }

    @Nullable
    public static SuccessFile safelyFromPath(FileIO fileIO, Path path) throws IOException {
        try {
            String json = fileIO.readFileUtf8(path);
            return SuccessFile.fromJson(json);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void close() {
    }
}

