/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.FileStorePathFactory;

public class ChangelogDeletion
extends FileDeletionBase<Changelog> {
    public ChangelogDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler, boolean cleanEmptyDirectories, int deleteFileThreadNum) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler, statsFileHandler, cleanEmptyDirectories, deleteFileThreadNum);
    }

    @Override
    public void cleanUnusedDataFiles(Changelog changelog, Predicate<ExpireFileEntry> skipper) {
        if (changelog.changelogManifestList() != null) {
            this.deleteAddedDataFiles(changelog.changelogManifestList());
        }
        if (this.manifestList.exists(changelog.deltaManifestList())) {
            this.cleanUnusedDataFiles(changelog.deltaManifestList(), skipper);
        }
    }

    @Override
    public void cleanUnusedManifests(Changelog changelog, Set<String> skippingSet) {
        if (changelog.changelogManifestList() != null) {
            this.cleanUnusedManifestList(changelog.changelogManifestList(), skippingSet);
        }
        if (this.manifestList.exists(changelog.deltaManifestList())) {
            this.cleanUnusedManifestList(changelog.deltaManifestList(), skippingSet);
        }
        if (this.manifestList.exists(changelog.baseManifestList())) {
            this.cleanUnusedManifestList(changelog.baseManifestList(), skippingSet);
        }
    }

    @Override
    public Set<String> manifestSkippingSet(List<Snapshot> skippingSnapshots) {
        HashSet<String> skippingSet = new HashSet<String>();
        for (Snapshot skippingSnapshot : skippingSnapshots) {
            String indexManifest;
            if (this.manifestList.exists(skippingSnapshot.baseManifestList())) {
                skippingSet.add(skippingSnapshot.baseManifestList());
                this.manifestList.read(skippingSnapshot.baseManifestList()).stream().map(ManifestFileMeta::fileName).forEach(skippingSet::add);
            }
            if (this.manifestList.exists(skippingSnapshot.deltaManifestList())) {
                skippingSet.add(skippingSnapshot.deltaManifestList());
                this.manifestList.read(skippingSnapshot.deltaManifestList()).stream().map(ManifestFileMeta::fileName).forEach(skippingSet::add);
            }
            if ((indexManifest = skippingSnapshot.indexManifest()) != null && this.indexFileHandler.existsManifest(indexManifest)) {
                skippingSet.add(indexManifest);
                this.indexFileHandler.readManifest(indexManifest).stream().map(IndexManifestEntry::indexFile).map(IndexFileMeta::fileName).forEach(skippingSet::add);
            }
            if (skippingSnapshot.statistics() == null) continue;
            skippingSet.add(skippingSnapshot.statistics());
        }
        return skippingSet;
    }
}

