/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.jar.jni;

import io.questdb.jar.jni.LoadException;
import io.questdb.jar.jni.Platform;
import io.questdb.jar.jni.PlatformConventions;
import io.questdb.jar.jni.StreamTransfer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public interface JarJniLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void loadLib(Class<T> cls, String jarPathPrefix, String name, String platformDir) {
        InputStream is;
        String sep = jarPathPrefix.endsWith("/") ? "" : "/";
        String pathInJar = jarPathPrefix + sep;
        if (platformDir != null) {
            pathInJar = pathInJar + platformDir + "/";
        }
        if ((is = cls.getResourceAsStream(pathInJar = pathInJar + PlatformConventions.LIB_PREFIX + name + PlatformConventions.LIB_SUFFIX)) == null) {
            throw new LoadException("Internal error: cannot find " + pathInJar + ", broken package?");
        }
        try {
            File tempLib = null;
            try {
                int dot = pathInJar.indexOf(46);
                tempLib = File.createTempFile(pathInJar.substring(0, dot), pathInJar.substring(dot));
                try (FileOutputStream out = new FileOutputStream(tempLib);){
                    StreamTransfer.copyToStream(is, out);
                }
                finally {
                    tempLib.deleteOnExit();
                }
                System.load(tempLib.getAbsolutePath());
            }
            catch (IOException e) {
                throw new LoadException("Internal error: cannot unpack " + tempLib, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static <T> void loadLib(Class<T> cls, String jarPathPrefix, String name) {
        JarJniLoader.loadLib(cls, jarPathPrefix, name, Platform.RESOURCE_PREFIX);
    }
}

