/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;

@Public
public final class GenericMap
implements InternalMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<?, ?> map;

    public GenericMap(Map<?, ?> map) {
        this.map = map;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public InternalArray keyArray() {
        Object[] keys = this.map.keySet().toArray();
        return new GenericArray(keys);
    }

    @Override
    public InternalArray valueArray() {
        Object[] values = this.map.values().toArray();
        return new GenericArray(values);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericMap)) {
            return false;
        }
        return GenericMap.deepEquals(this.map, ((GenericMap)o).map);
    }

    private static <K, V> boolean deepEquals(Map<K, V> m1, Map<?, ?> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : m1.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m2.get(key) != null || !m2.containsKey(key) : !Objects.deepEquals(value, m2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Object key : this.map.keySet()) {
            result += 31 * Objects.hashCode(key);
        }
        return result;
    }
}

