/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.job.JobTemplate;

public class SparkJobTemplate
extends JobTemplate {
    private final String className;
    private final List<String> jars;
    private final List<String> files;
    private final List<String> archives;
    private final Map<String, String> configs;

    protected SparkJobTemplate(Builder builder) {
        super(builder);
        this.className = builder.className;
        this.jars = builder.jars;
        this.files = builder.files;
        this.archives = builder.archives;
        this.configs = builder.configs;
    }

    public String className() {
        return this.className;
    }

    public List<String> jars() {
        return this.jars;
    }

    public List<String> files() {
        return this.files;
    }

    public List<String> archives() {
        return this.archives;
    }

    public Map<String, String> configs() {
        return this.configs;
    }

    @Override
    public JobTemplate.JobType jobType() {
        return JobTemplate.JobType.SPARK;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SparkJobTemplate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SparkJobTemplate that = (SparkJobTemplate)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.jars, that.jars) && Objects.equals(this.files, that.files) && Objects.equals(this.archives, that.archives) && Objects.equals(this.configs, that.configs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.className, this.jars, this.files, this.archives, this.configs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("\nSparkJobTemplate{\n");
        sb.append("  className='").append(this.className).append("',\n");
        if (!this.jars.isEmpty()) {
            sb.append("  jars=[\n");
            this.jars.forEach(j -> sb.append("    ").append((String)j).append("\n"));
            sb.append("  ],\n");
        } else {
            sb.append("  jars=[],\n");
        }
        if (!this.files.isEmpty()) {
            sb.append("  files=[\n");
            this.files.forEach(f -> sb.append("    ").append((String)f).append("\n"));
            sb.append("  ],\n");
        } else {
            sb.append("  files=[],\n");
        }
        if (!this.archives.isEmpty()) {
            sb.append("  archives=[\n");
            this.archives.forEach(a -> sb.append("    ").append((String)a).append("\n"));
            sb.append("  ],\n");
        } else {
            sb.append("  archives=[],\n");
        }
        if (!this.configs.isEmpty()) {
            sb.append("  configs={\n");
            this.configs.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append((String)v).append(",\n"));
            sb.append("  }\n");
        } else {
            sb.append("  configs={}\n");
        }
        return String.valueOf(sb) + super.toString() + "}\n";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JobTemplate.BaseBuilder<Builder, SparkJobTemplate> {
        private String className;
        private List<String> jars;
        private List<String> files;
        private List<String> archives;
        private Map<String, String> configs;

        private Builder() {
        }

        public Builder withClassName(String className) {
            this.className = className;
            return this;
        }

        public Builder withJars(List<String> jars) {
            this.jars = jars;
            return this;
        }

        public Builder withFiles(List<String> files) {
            this.files = files;
            return this;
        }

        public Builder withArchives(List<String> archives) {
            this.archives = archives;
            return this;
        }

        public Builder withConfigs(Map<String, String> configs) {
            this.configs = configs;
            return this;
        }

        @Override
        public SparkJobTemplate build() {
            this.validate();
            return new SparkJobTemplate(this);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.className), (Object)"Class name must not be null or empty");
            this.jars = this.jars != null ? ImmutableList.copyOf(this.jars) : ImmutableList.of();
            this.files = this.files != null ? ImmutableList.copyOf(this.files) : ImmutableList.of();
            this.archives = this.archives != null ? ImmutableList.copyOf(this.archives) : ImmutableList.of();
            this.configs = this.configs != null ? ImmutableMap.copyOf(this.configs) : ImmutableMap.of();
        }
    }
}

