/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.utils.Preconditions;

public class NoopCompactManager
implements CompactManager {
    @Override
    public boolean shouldWaitForLatestCompaction() {
        return false;
    }

    @Override
    public boolean shouldWaitForPreparingCheckpoint() {
        return false;
    }

    @Override
    public void addNewFile(DataFileMeta file) {
    }

    public List<DataFileMeta> allFiles() {
        return Collections.emptyList();
    }

    @Override
    public void triggerCompaction(boolean fullCompaction) {
        Preconditions.checkArgument((!fullCompaction ? 1 : 0) != 0, (Object)("NoopCompactManager does not support user triggered compaction.\nIf you really need a guaranteed compaction, please set " + CoreOptions.WRITE_ONLY.key() + " property of this table to false."));
    }

    @Override
    public Optional<CompactResult> getCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        return Optional.empty();
    }

    @Override
    public void cancelCompaction() {
    }

    @Override
    public boolean isCompacting() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }
}

