/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.outputs;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.types.Type;

public class LineUtil {
    private static final Pattern FULL_WIDTH_PATTERN = Pattern.compile("[\u1100-\u115f\u2e80-\ua4cf\uac00-\ud7a3\uf900-\ufaff\ufe10-\ufe19\ufe30-\ufe6f\uff00-\uff60\uffe0-\uffe6]");
    public static final String EMPTY_DEFAULT_VALUE = "";
    public static final String EMPTY_STRING_TYPE_DEFAULT_VALUE = "''";

    public static int getDisplayWidth(String str) {
        int width = 0;
        for (int i = 0; i < str.length(); ++i) {
            width += LineUtil.getCharWidth(str.charAt(i));
        }
        return width;
    }

    private static int getCharWidth(char ch) {
        String s2 = String.valueOf(ch);
        if (FULL_WIDTH_PATTERN.matcher(s2).find()) {
            return 2;
        }
        return 1;
    }

    public static String getSpaces(int n) {
        Preconditions.checkArgument(n >= 0, "n must be non-negative");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String capitalize(String str) {
        int codePoint;
        int newCodePoint;
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String getDefaultValue(Column column) {
        Expression defaultValue = column.defaultValue();
        if (defaultValue == null || defaultValue == Column.DEFAULT_VALUE_NOT_SET) {
            return EMPTY_DEFAULT_VALUE;
        }
        if (defaultValue instanceof Literal && ((Literal)defaultValue).value() != null) {
            String defaultValueStr = ((Literal)defaultValue).value().toString().trim();
            if (EMPTY_DEFAULT_VALUE.equalsIgnoreCase(defaultValueStr) && LineUtil.isStringType(column)) {
                return EMPTY_STRING_TYPE_DEFAULT_VALUE;
            }
            return defaultValueStr;
        }
        if (defaultValue instanceof FunctionExpression) {
            return defaultValue.toString();
        }
        if (defaultValue.references().length == 0) {
            return EMPTY_DEFAULT_VALUE;
        }
        return Arrays.toString(defaultValue.references());
    }

    public static String getAutoIncrement(Column column) {
        if (LineUtil.isIntegerType(column)) {
            return column.autoIncrement() ? "true" : "false";
        }
        return EMPTY_DEFAULT_VALUE;
    }

    public static boolean isIntegerType(Column column) {
        Type.Name columnTypeName = column.dataType().name();
        return columnTypeName == Type.Name.LONG || columnTypeName == Type.Name.INTEGER || columnTypeName == Type.Name.SHORT || columnTypeName == Type.Name.BYTE;
    }

    public static boolean isStringType(Column column) {
        Type.Name columnTypeName = column.dataType().name();
        return columnTypeName == Type.Name.STRING || columnTypeName == Type.Name.VARCHAR || columnTypeName == Type.Name.FIXEDCHAR;
    }

    public static String getComment(Column column) {
        return column.comment() == null ? "N/A" : column.comment();
    }
}

