/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.tag.Tag;

public class TagDetails
extends Command {
    protected final String metalake;
    protected final String tag;

    public TagDetails(CommandContext context, String metalake, String tag) {
        super(context);
        this.metalake = metalake;
        this.tag = tag;
    }

    @Override
    public void handle() {
        Tag result = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            result = client.getTag(this.tag);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (result != null) {
            this.printResults(result.name() + "," + result.comment());
        }
    }
}

