/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.CatalogNotInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterCatalogEvent;
import org.apache.gravitino.listener.api.event.AlterCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.AlterCatalogPreEvent;
import org.apache.gravitino.listener.api.event.CreateCatalogEvent;
import org.apache.gravitino.listener.api.event.CreateCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.CreateCatalogPreEvent;
import org.apache.gravitino.listener.api.event.DropCatalogEvent;
import org.apache.gravitino.listener.api.event.DropCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.DropCatalogPreEvent;
import org.apache.gravitino.listener.api.event.ListCatalogEvent;
import org.apache.gravitino.listener.api.event.ListCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.ListCatalogPreEvent;
import org.apache.gravitino.listener.api.event.LoadCatalogEvent;
import org.apache.gravitino.listener.api.event.LoadCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.LoadCatalogPreEvent;
import org.apache.gravitino.listener.api.info.CatalogInfo;
import org.apache.gravitino.utils.PrincipalUtils;

public class CatalogEventDispatcher
implements CatalogDispatcher {
    private final EventBus eventBus;
    private final CatalogDispatcher dispatcher;

    public CatalogEventDispatcher(EventBus eventBus, CatalogDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    @Override
    public NameIdentifier[] listCatalogs(Namespace namespace) throws NoSuchMetalakeException {
        this.eventBus.dispatchEvent(new ListCatalogPreEvent(PrincipalUtils.getCurrentUserName(), namespace));
        try {
            NameIdentifier[] nameIdentifiers = this.dispatcher.listCatalogs(namespace);
            this.eventBus.dispatchEvent(new ListCatalogEvent(PrincipalUtils.getCurrentUserName(), namespace));
            return nameIdentifiers;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListCatalogFailureEvent(PrincipalUtils.getCurrentUserName(), e, namespace));
            throw e;
        }
    }

    @Override
    public Catalog[] listCatalogsInfo(Namespace namespace) throws NoSuchMetalakeException {
        this.eventBus.dispatchEvent(new ListCatalogPreEvent(PrincipalUtils.getCurrentUserName(), namespace));
        try {
            Catalog[] catalogs = this.dispatcher.listCatalogsInfo(namespace);
            this.eventBus.dispatchEvent(new ListCatalogEvent(PrincipalUtils.getCurrentUserName(), namespace));
            return catalogs;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListCatalogFailureEvent(PrincipalUtils.getCurrentUserName(), e, namespace));
            throw e;
        }
    }

    @Override
    public Catalog loadCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        this.eventBus.dispatchEvent(new LoadCatalogPreEvent(PrincipalUtils.getCurrentUserName(), ident));
        try {
            Catalog catalog = this.dispatcher.loadCatalog(ident);
            this.eventBus.dispatchEvent(new LoadCatalogEvent(PrincipalUtils.getCurrentUserName(), ident, new CatalogInfo(catalog)));
            return catalog;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LoadCatalogFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public Catalog createCatalog(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        CatalogInfo catalogInfo = new CatalogInfo(ident.name(), type, provider, comment, properties, null);
        this.eventBus.dispatchEvent(new CreateCatalogPreEvent(PrincipalUtils.getCurrentUserName(), ident, catalogInfo));
        try {
            Catalog catalog = this.dispatcher.createCatalog(ident, type, provider, comment, properties);
            this.eventBus.dispatchEvent(new CreateCatalogEvent(PrincipalUtils.getCurrentUserName(), ident, new CatalogInfo(catalog)));
            return catalog;
        }
        catch (Exception e) {
            CatalogInfo createCatalogRequest = new CatalogInfo(ident.name(), type, provider, comment, properties, null);
            this.eventBus.dispatchEvent(new CreateCatalogFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, createCatalogRequest));
            throw e;
        }
    }

    @Override
    public Catalog alterCatalog(NameIdentifier ident, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        this.eventBus.dispatchEvent(new AlterCatalogPreEvent(PrincipalUtils.getCurrentUserName(), ident, changes));
        try {
            Catalog catalog = this.dispatcher.alterCatalog(ident, changes);
            this.eventBus.dispatchEvent(new AlterCatalogEvent(PrincipalUtils.getCurrentUserName(), ident, changes, new CatalogInfo(catalog)));
            return catalog;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterCatalogFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, changes));
            throw e;
        }
    }

    @Override
    public boolean dropCatalog(NameIdentifier ident, boolean force) throws NonEmptyEntityException, CatalogInUseException {
        this.eventBus.dispatchEvent(new DropCatalogPreEvent(PrincipalUtils.getCurrentUserName(), ident));
        try {
            boolean isExists = this.dispatcher.dropCatalog(ident, force);
            this.eventBus.dispatchEvent(new DropCatalogEvent(PrincipalUtils.getCurrentUserName(), ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropCatalogFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public void testConnection(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        this.dispatcher.testConnection(ident, type, provider, comment, properties);
    }

    @Override
    public void enableCatalog(NameIdentifier ident) throws NoSuchCatalogException, CatalogNotInUseException {
        this.dispatcher.enableCatalog(ident);
    }

    @Override
    public void disableCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        this.dispatcher.disableCatalog(ident);
    }
}

