/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Locale;
import org.apache.flink.annotation.Internal;

@Internal
public enum LikeType {
    LIKE("LIKE"),
    ILIKE("ILIKE"),
    NOT_LIKE("NOT LIKE"),
    NOT_ILIKE("NOT ILIKE");

    private final String name;

    private LikeType(String name) {
        this.name = name;
    }

    public static LikeType of(String type) {
        return LikeType.valueOf(type.toUpperCase(Locale.ROOT));
    }

    public static LikeType of(String type, boolean notLike) {
        if (type == null) {
            return null;
        }
        LikeType likeType = LikeType.valueOf(type.toUpperCase(Locale.ROOT));
        if (notLike) {
            if (likeType == LIKE) {
                return NOT_LIKE;
            }
            return NOT_ILIKE;
        }
        return likeType;
    }

    public boolean isNot() {
        return this == NOT_LIKE || this == NOT_ILIKE;
    }

    public boolean isILike() {
        return this == ILIKE || this == NOT_ILIKE;
    }

    public static LikeType of(boolean isILike, boolean notLike) {
        if (isILike) {
            return notLike ? NOT_ILIKE : ILIKE;
        }
        return notLike ? NOT_LIKE : LIKE;
    }

    public String asSummaryString() {
        return this.name;
    }
}

