/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.source;

import java.util.Collection;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceReaderFactory;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.lib.NumberSequenceSource;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.connector.datagen.source.GeneratorSourceReaderFactory;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.util.Preconditions;

@Experimental
public class DataGeneratorSource<OUT>
implements Source<OUT, NumberSequenceSource.NumberSequenceSplit, Collection<NumberSequenceSource.NumberSequenceSplit>>,
ResultTypeQueryable<OUT>,
OutputTypeConfigurable<OUT> {
    private static final long serialVersionUID = 1L;
    private final SourceReaderFactory<OUT, NumberSequenceSource.NumberSequenceSplit> sourceReaderFactory;
    private TypeInformation<OUT> typeInfo;
    private final NumberSequenceSource numberSource;
    private final GeneratorFunction<Long, OUT> generatorFunction;

    public DataGeneratorSource(GeneratorFunction<Long, OUT> generatorFunction, long count, TypeInformation<OUT> typeInfo) {
        this(generatorFunction, count, RateLimiterStrategy.noOp(), typeInfo);
    }

    public DataGeneratorSource(GeneratorFunction<Long, OUT> generatorFunction, long count, RateLimiterStrategy rateLimiterStrategy, TypeInformation<OUT> typeInfo) {
        this(new GeneratorSourceReaderFactory<OUT>(generatorFunction, rateLimiterStrategy), generatorFunction, count, typeInfo);
        ClosureCleaner.clean((Object)rateLimiterStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    DataGeneratorSource(SourceReaderFactory<OUT, NumberSequenceSource.NumberSequenceSplit> sourceReaderFactory, GeneratorFunction<Long, OUT> generatorFunction, long count, TypeInformation<OUT> typeInfo) {
        this.sourceReaderFactory = (SourceReaderFactory)Preconditions.checkNotNull(sourceReaderFactory);
        this.generatorFunction = (GeneratorFunction)Preconditions.checkNotNull(generatorFunction);
        this.typeInfo = (TypeInformation)Preconditions.checkNotNull(typeInfo);
        long to = count > 0L ? count - 1L : 0L;
        this.numberSource = new NumberSequenceSource(0L, to);
        ClosureCleaner.clean(generatorFunction, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        ClosureCleaner.clean(sourceReaderFactory, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    public void setOutputType(TypeInformation<OUT> outTypeInfo, ExecutionConfig executionConfig) {
        this.typeInfo = outTypeInfo;
        if (this.generatorFunction instanceof OutputTypeConfigurable) {
            ((OutputTypeConfigurable)this.generatorFunction).setOutputType(outTypeInfo, executionConfig);
        }
    }

    @VisibleForTesting
    public GeneratorFunction<Long, OUT> getGeneratorFunction() {
        return this.generatorFunction;
    }

    public TypeInformation<OUT> getProducedType() {
        return this.typeInfo;
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SourceReader<OUT, NumberSequenceSource.NumberSequenceSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return this.sourceReaderFactory.createReader(readerContext);
    }

    public SplitEnumerator<NumberSequenceSource.NumberSequenceSplit, Collection<NumberSequenceSource.NumberSequenceSplit>> restoreEnumerator(SplitEnumeratorContext<NumberSequenceSource.NumberSequenceSplit> enumContext, Collection<NumberSequenceSource.NumberSequenceSplit> checkpoint) {
        return this.numberSource.restoreEnumerator(enumContext, checkpoint);
    }

    public SplitEnumerator<NumberSequenceSource.NumberSequenceSplit, Collection<NumberSequenceSource.NumberSequenceSplit>> createEnumerator(SplitEnumeratorContext<NumberSequenceSource.NumberSequenceSplit> enumContext) {
        return this.numberSource.createEnumerator(enumContext);
    }

    public SimpleVersionedSerializer<NumberSequenceSource.NumberSequenceSplit> getSplitSerializer() {
        return this.numberSource.getSplitSerializer();
    }

    public SimpleVersionedSerializer<Collection<NumberSequenceSource.NumberSequenceSplit>> getEnumeratorCheckpointSerializer() {
        return this.numberSource.getEnumeratorCheckpointSerializer();
    }
}

