/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;

public class Expander {
    private final FlinkPlannerImpl planner;

    private Expander(FlinkPlannerImpl planner) {
        this.planner = Objects.requireNonNull(planner);
    }

    public static Expander create(FlinkPlannerImpl planner) {
        return new Expander(planner);
    }

    public Expanded expanded(String ori) {
        final HashMap<SqlParserPos, SqlIdentifier> identifiers = new HashMap<SqlParserPos, SqlIdentifier>();
        final HashMap<String, SqlIdentifier> funcNameToId = new HashMap<String, SqlIdentifier>();
        SqlNode oriNode = this.planner.parser().parse(ori);
        SqlNode validated = this.planner.validate(this.planner.parser().parse(ori));
        validated.accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                SqlIdentifier functionID;
                SqlOperator operator = call.getOperator();
                if (operator instanceof BridgingSqlFunction && !(functionID = ((BridgingSqlFunction)operator).getSqlIdentifier()).isSimple()) {
                    funcNameToId.put(Util.last(functionID.names), functionID);
                }
                return (Void)super.visit(call);
            }

            @Override
            public Void visit(SqlIdentifier identifier) {
                if (!((String)identifier.names.get(0)).startsWith("EXPR$")) {
                    identifiers.putIfAbsent(identifier.getParserPosition(), identifier);
                }
                return null;
            }
        });
        return new Expanded(oriNode, identifiers, funcNameToId);
    }

    public static class Expanded {
        private final SqlNode oriNode;
        private final Map<SqlParserPos, SqlIdentifier> identifiersMap;
        private final Map<String, SqlIdentifier> funcNameToId;

        Expanded(SqlNode oriNode, Map<SqlParserPos, SqlIdentifier> identifiers, Map<String, SqlIdentifier> funcNameToId) {
            this.oriNode = oriNode;
            this.identifiersMap = ImmutableMap.copyOf(identifiers);
            this.funcNameToId = ImmutableMap.copyOf(funcNameToId);
        }

        public String toString() {
            return this.substitute(SqlNode::toString);
        }

        public String substitute(Function<SqlNode, String> fn) {
            SqlShuttle shuttle = new SqlShuttle(){

                @Override
                public SqlNode visit(SqlCall call) {
                    SqlUnresolvedFunction unresolvedFunction;
                    SqlIdentifier functionID;
                    SqlOperator operator = call.getOperator();
                    if (operator instanceof SqlUnresolvedFunction && (functionID = (unresolvedFunction = (SqlUnresolvedFunction)operator).getSqlIdentifier()).isSimple() && funcNameToId.containsKey(functionID.getSimple())) {
                        SqlUnresolvedFunction newFunc = new SqlUnresolvedFunction(funcNameToId.get(functionID.getSimple()), unresolvedFunction.getReturnTypeInference(), unresolvedFunction.getOperandTypeInference(), unresolvedFunction.getOperandTypeChecker(), unresolvedFunction.getParamTypes(), unresolvedFunction.getFunctionType());
                        return newFunc.createCall(call.getFunctionQuantifier(), call.getParserPosition(), call.getOperandList().toArray(new SqlNode[0]));
                    }
                    return super.visit(call);
                }

                @Override
                public SqlNode visit(SqlIdentifier id) {
                    if (id.isStar()) {
                        return id;
                    }
                    SqlIdentifier toReplace = identifiersMap.get(id.getParserPosition());
                    if (toReplace == null || id.names.size() >= toReplace.names.size()) {
                        return id;
                    }
                    return toReplace;
                }
            };
            SqlNode substituted = this.oriNode.accept(shuttle);
            return fn.apply(substituted);
        }
    }
}

