/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.conversion.DayTimeIntervalDurationConverter;
import org.apache.flink.table.data.conversion.YearMonthIntervalPeriodConverter;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.NestedFieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.plan.utils.NestedColumn;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil$;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter$;
import org.apache.flink.table.planner.utils.TimestampStringUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001\u0002\u000e\u001c\u0001)B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!)\u0007A!A!\u0002\u00131\u0007\"B8\u0001\t\u0003\u0001\b\"B8\u0001\t\u0003A\b\"B?\u0001\t\u0003r\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u0011Q\f\u0001\u0005B\u0005}\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!!&\u0001\t\u0003\n9\nC\u0004\u0002$\u0002!I!!*\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\u001eI\u0011q\\\u000e\u0002\u0002#\u0005\u0011\u0011\u001d\u0004\t5m\t\t\u0011#\u0001\u0002d\"1qn\u0006C\u0001\u0003WD\u0011\"!<\u0018#\u0003%\t!a<\u00039I+\u0007PT8eKR{W\t\u001f9sKN\u001c\u0018n\u001c8D_:4XM\u001d;fe*\u0011A$H\u0001\u0006kRLGn\u001d\u0006\u0003=}\tA\u0001\u001d7b]*\u0011\u0001%I\u0001\ba2\fgN\\3s\u0015\t\u00113%A\u0003uC\ndWM\u0003\u0002%K\u0005)a\r\\5oW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00164!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u00142kK\u000e$\bc\u0001\u001b:w5\tQG\u0003\u00027o\u0005\u0019!/\u001a=\u000b\u0005a*\u0013aB2bY\u000eLG/Z\u0005\u0003uU\u0012!BU3y-&\u001c\u0018\u000e^8s!\rat(Q\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1q\n\u001d;j_:\u0004\"AQ#\u000e\u0003\rS!\u0001R\u0011\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\r\u000e\u0013!CU3t_24X\rZ#yaJ,7o]5p]\u0006Q!/\u001a=Ck&dG-\u001a:\u0011\u0005QJ\u0015B\u0001&6\u0005)\u0011V\r\u001f\"vS2$WM]\u0001\u000bS:\u0004X\u000f\u001e(b[\u0016\u001c\bc\u0001\u001fN\u001f&\u0011a*\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003!^s!!U+\u0011\u0005IkT\"A*\u000b\u0005QK\u0013A\u0002\u001fs_>$h(\u0003\u0002W{\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1V(A\bgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h!\tav,D\u0001^\u0015\tq\u0016%A\u0004dCR\fGn\\4\n\u0005\u0001l&a\u0004$v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feB\u0011AlY\u0005\u0003Iv\u0013abQ1uC2|w-T1oC\u001e,'/A\u0006sK2$\u0015\r^1UsB,\u0007c\u0001\u001f@OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005if\u0004XM\u0003\u0002mo\u0005\u0019!/\u001a7\n\u00059L'a\u0003*fY\u0012\u000bG/\u0019+za\u0016\fa\u0001P5oSRtDCB9tiV4x\u000f\u0005\u0002s\u00015\t1\u0004C\u0003H\r\u0001\u0007\u0001\nC\u0003L\r\u0001\u0007A\nC\u0003[\r\u0001\u00071\fC\u0003b\r\u0001\u0007!\rC\u0004f\rA\u0005\t\u0019\u00014\u0015\u000bEL(p\u001f?\t\u000b\u001d;\u0001\u0019\u0001%\t\u000b-;\u0001\u0019\u0001'\t\u000bi;\u0001\u0019A.\t\u000b\u0005<\u0001\u0019\u00012\u0002\u001bYL7/\u001b;J]B,HOU3g)\tYt\u0010C\u0004\u0002\u0002!\u0001\r!a\u0001\u0002\u0011%t\u0007/\u001e;SK\u001a\u00042\u0001NA\u0003\u0013\r\t9!\u000e\u0002\f%\u0016D\u0018J\u001c9viJ+g-\u0001\nwSNLG\u000fV1cY\u0016Le\u000e];u%\u00164GcA\u001e\u0002\u000e!9\u0011qB\u0005A\u0002\u0005E\u0011\u0001\u0005:fqR\u000b'\r\\3J]B,HOU3g!\r!\u00141C\u0005\u0004\u0003+)$\u0001\u0005*fqR\u000b'\r\\3J]B,HOU3g\u000351\u0018n]5u\u0019>\u001c\u0017\r\u001c*fMR\u00191(a\u0007\t\u000f\u0005u!\u00021\u0001\u0002 \u0005AAn\\2bYJ+g\rE\u00025\u0003CI1!a\t6\u0005-\u0011V\r\u001f'pG\u0006d'+\u001a4\u0002\u0019YL7/\u001b;MSR,'/\u00197\u0015\u0007m\nI\u0003C\u0004\u0002,-\u0001\r!!\f\u0002\u000f1LG/\u001a:bYB\u0019A'a\f\n\u0007\u0005ERG\u0001\u0006SKbd\u0015\u000e^3sC2\f\u0011B^5tSR\u001c\u0015\r\u001c7\u0015\u0007m\n9\u0004C\u0004\u0002:1\u0001\r!a\u000f\u0002\u0015=\u0014\u0018NU3y\u0007\u0006dG\u000eE\u00025\u0003{I1!a\u00106\u0005\u001d\u0011V\r_\"bY2\f\u0001C^5tSR4\u0015.\u001a7e\u0003\u000e\u001cWm]:\u0015\u0007m\n)\u0005C\u0004\u0002H5\u0001\r!!\u0013\u0002\u0017\u0019LW\r\u001c3BG\u000e,7o\u001d\t\u0004i\u0005-\u0013bAA'k\tq!+\u001a=GS\u0016dG-Q2dKN\u001c\u0018a\u0005<jg&$8i\u001c:sK24\u0016M]5bE2,GcA\u001e\u0002T!9\u0011Q\u000b\bA\u0002\u0005]\u0013AD2peJ,GNV1sS\u0006\u0014G.\u001a\t\u0004i\u0005e\u0013bAA.k\t\t\"+\u001a=D_J\u0014X\r\u001c,be&\f'\r\\3\u0002\u001bYL7/\u001b;SC:<WMU3g)\rY\u0014\u0011\r\u0005\b\u0003Gz\u0001\u0019AA3\u0003!\u0011\u0018M\\4f%\u00164\u0007c\u0001\u001b\u0002h%\u0019\u0011\u0011N\u001b\u0003\u0017I+\u0007PU1oO\u0016\u0014VMZ\u0001\u000em&\u001c\u0018\u000e^*vEF+XM]=\u0015\u0007m\ny\u0007C\u0004\u0002rA\u0001\r!a\u001d\u0002\u0011M,(-U;fef\u00042\u0001NA;\u0013\r\t9(\u000e\u0002\f%\u0016D8+\u001e2Rk\u0016\u0014\u00180A\twSNLG\u000fR=oC6L7\rU1sC6$2aOA?\u0011\u001d\ty(\u0005a\u0001\u0003\u0003\u000bA\u0002Z=oC6L7\rU1sC6\u00042\u0001NAB\u0013\r\t))\u000e\u0002\u0010%\u0016DH)\u001f8b[&\u001c\u0007+\u0019:b[\u0006Ia/[:ji>3XM\u001d\u000b\u0004w\u0005-\u0005bBAG%\u0001\u0007\u0011qR\u0001\u0005_Z,'\u000fE\u00025\u0003#K1!a%6\u0005\u001d\u0011V\r_(wKJ\fAC^5tSR\u0004\u0016\r\u001e;fe:4\u0015.\u001a7e%\u00164GcA\u001e\u0002\u001a\"9\u00111T\nA\u0002\u0005u\u0015\u0001\u00034jK2$'+\u001a4\u0011\u0007Q\ny*C\u0002\u0002\"V\u0012!CU3y!\u0006$H/\u001a:o\r&,G\u000e\u001a*fM\u0006qAn\\8lkB4UO\\2uS>tGcB\u001e\u0002(\u0006E\u0016q\u0019\u0005\b\u0003S#\u0002\u0019AAV\u0003)IG-\u001a8uS\u001aLWM\u001d\t\u00049\u00065\u0016bAAX;\n!RK\u001c:fg>dg/\u001a3JI\u0016tG/\u001b4jKJDq!a-\u0015\u0001\u0004\t),\u0001\u0005pa\u0016\u0014\u0018M\u001c3t!\u0015\t9,!1B\u001d\u0011\tI,!0\u000f\u0007I\u000bY,C\u0001?\u0013\r\ty,P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019-!2\u0003\u0007M+\u0017OC\u0002\u0002@vBq!!3\u0015\u0001\u0004\tY-\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#\f\u0013!\u0002;za\u0016\u001c\u0018\u0002BAk\u0003\u001f\u0014\u0001\u0002R1uCRK\b/Z\u0001\be\u0016\u0004H.Y2f)\ry\u00151\u001c\u0005\u0007\u0003;,\u0002\u0019A(\u0002\u0007M$(/\u0001\u000fSKbtu\u000eZ3U_\u0016C\bO]3tg&|gnQ8om\u0016\u0014H/\u001a:\u0011\u0005I<2cA\f\u0002fB\u0019A(a:\n\u0007\u0005%XH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003C\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAAyU\r1\u00171_\u0016\u0003\u0003k\u0004B!a>\u0003\u00025\u0011\u0011\u0011 \u0006\u0005\u0003w\fi0A\u0005v]\u000eDWmY6fI*\u0019\u0011q`\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0004\u0005e(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class RexNodeToExpressionConverter
implements RexVisitor<Option<ResolvedExpression>> {
    private final RexBuilder rexBuilder;
    private final String[] inputNames;
    private final FunctionCatalog functionCatalog;
    private final Option<RelDataType> relDataType;

    public static Option<RelDataType> $lessinit$greater$default$5() {
        return RexNodeToExpressionConverter$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public void visitList(Iterable<? extends RexNode> x$1, java.util.List<Option<ResolvedExpression>> x$2) {
        RexVisitor.super.visitList(x$1, x$2);
    }

    @Override
    public java.util.List<Option<ResolvedExpression>> visitList(Iterable<? extends RexNode> x$1) {
        return RexVisitor.super.visitList(x$1);
    }

    @Override
    public void visitEach(Iterable<? extends RexNode> x$1) {
        RexVisitor.super.visitEach(x$1);
    }

    @Override
    public Option<ResolvedExpression> visitInputRef(RexInputRef inputRef) {
        Preconditions.checkArgument((inputRef.getIndex() < this.inputNames.length ? 1 : 0) != 0);
        return new Some((Object)new FieldReferenceExpression(this.inputNames[inputRef.getIndex()], LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(inputRef.getType())), 0, inputRef.getIndex()));
    }

    @Override
    public Option<ResolvedExpression> visitTableInputRef(RexTableInputRef rexTableInputRef) {
        return this.visitInputRef(rexTableInputRef);
    }

    @Override
    public Option<ResolvedExpression> visitLocalRef(RexLocalRef localRef) {
        throw new TableException("Bug: RexLocalRef should have been expanded");
    }

    @Override
    public Option<ResolvedExpression> visitLiteral(RexLiteral literal) {
        Object object;
        Comparable comparable = literal.getValue();
        if (comparable instanceof SqlTrimFunction.Flag) {
            return None$.MODULE$;
        }
        LogicalType literalType = FlinkTypeFactory$.MODULE$.toLogicalType(literal.getType());
        LogicalTypeRoot logicalTypeRoot = literalType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = DataFormatConverters.LocalDateConverter.INSTANCE.toExternal((Object)v);
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = DataFormatConverters.LocalTimeConverter.INSTANCE.toExternal((Object)v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            object = TimestampStringUtils.toLocalDateTime(v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            object = TimestampStringUtils.toLocalDateTime(v).atZone(ZoneId.of(ZoneOffset.UTC.getId())).toInstant();
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            Long v = literal.getValueAs(Long.class);
            object = DayTimeIntervalDurationConverter.INSTANCE.toExternal(v);
        } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = YearMonthIntervalPeriodConverter.create((YearMonthIntervalType)((YearMonthIntervalType)literalType)).toExternal(v);
        } else {
            object = LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? literal.getValueAs(Byte.class) : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? literal.getValueAs(Short.class) : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? literal.getValueAs(Integer.class) : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? literal.getValueAs(Long.class) : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? literal.getValueAs(Float.class) : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? literal.getValueAs(Double.class) : ((LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot)) ? literal.getValueAs(String.class) : (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot) ? literal.getValueAs(Boolean.class) : (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) ? literal.getValueAs(BigDecimal.class) : ((LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot)) ? (Object)literal.getValueAs(byte[].class) : literal.getValue())))))))));
        }
        Object literalValue = object;
        DataType dataType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)literalType);
        if (literalValue == null) {
            return new Some((Object)ApiExpressionUtils.valueLiteral(null, (DataType)((DataType)dataType.nullable())));
        }
        return new Some((Object)ApiExpressionUtils.valueLiteral((Object)literalValue, (DataType)((DataType)dataType.notNull())));
    }

    @Override
    public Option<ResolvedExpression> visitCall(RexCall oriRexCall) {
        RexCall rexCall = (RexCall)FlinkRexUtil$.MODULE$.expandSearch(this.rexBuilder, oriRexCall);
        Buffer operands = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)operand -> (ResolvedExpression)operand.accept(this).orNull(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom());
        DataType outputType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(rexCall.getType()));
        if (operands.contains(null)) {
            return None$.MODULE$;
        }
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.OR;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            return Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.OR, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon(l, (List)new .colon.colon(r, (List)Nil$.MODULE$))), (DataType)outputType)));
        }
        SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.AND;
        SqlOperator sqlOperator3 = sqlOperator;
        if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
            return Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.AND, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon(l, (List)new .colon.colon(r, (List)Nil$.MODULE$))), (DataType)outputType)));
        }
        SqlFunction sqlFunction = SqlStdOperatorTable.CAST;
        SqlOperator sqlOperator4 = sqlOperator;
        if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator4) : sqlOperator4 != null)) {
            return Option$.MODULE$.apply((Object)CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.CAST, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)((ResolvedExpression)operands.head()), (List)new .colon.colon((Object)ApiExpressionUtils.typeLiteral((DataType)outputType), (List)Nil$.MODULE$))), (DataType)outputType));
        }
        SqlFunction sqlFunction2 = FlinkSqlOperatorTable.TRY_CAST;
        SqlOperator sqlOperator5 = sqlOperator;
        if (!(sqlFunction2 != null ? !((Object)sqlFunction2).equals(sqlOperator5) : sqlOperator5 != null)) {
            return Option$.MODULE$.apply((Object)CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.TRY_CAST, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)((ResolvedExpression)operands.head()), (List)new .colon.colon((Object)ApiExpressionUtils.typeLiteral((DataType)outputType), (List)Nil$.MODULE$))), (DataType)outputType));
        }
        if (sqlOperator instanceof SqlFunction ? true : sqlOperator instanceof SqlPostfixOperator) {
            ArrayList<String> names = new ArrayList<String>(rexCall.getOperator().getNameAsId().names);
            names.set(names.size() - 1, this.replace(names.get(names.size() - 1)));
            UnresolvedIdentifier id = UnresolvedIdentifier.of((String[])((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(names).asScala()).toArray(ClassTag$.MODULE$.apply(String.class))));
            return this.lookupFunction(id, (Seq<ResolvedExpression>)operands, outputType);
        }
        return this.lookupFunction(UnresolvedIdentifier.of((String[])new String[]{this.replace(String.valueOf((Object)sqlOperator.getKind()))}), (Seq<ResolvedExpression>)operands, outputType);
    }

    @Override
    public Option<ResolvedExpression> visitFieldAccess(RexFieldAccess fieldAccess) {
        RexNode rexNode = fieldAccess.getReferenceExpr();
        if (rexNode instanceof RexCall) {
            return None$.MODULE$;
        }
        Option<RelDataType> option = this.relDataType;
        if (option instanceof Some) {
            Some some = (Some)option;
            RelDataType dataType = (RelDataType)some.value();
            NestedSchema schema = NestedProjectionUtil$.MODULE$.build(Collections.singletonList(fieldAccess), dataType);
            int[][] fieldIndices = NestedProjectionUtil$.MODULE$.convertToIndexArray(schema);
            Tuple2 tuple2 = (Tuple2)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(schema.columns()).head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topLevelColumnName = (String)tuple2._1();
            NestedColumn nestedColumn = (NestedColumn)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topLevelColumnName, (Object)nestedColumn);
            String topLevelColumnName2 = (String)tuple22._1();
            NestedColumn nestedColumn2 = (NestedColumn)tuple22._2();
            ArrayBuffer fieldNames = new ArrayBuffer();
            while (!nestedColumn2.isLeaf()) {
                JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)fieldNames).add(topLevelColumnName2);
                topLevelColumnName2 = (String)((Tuple2)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(nestedColumn2.children()).head())._1();
                nestedColumn2 = (NestedColumn)((Tuple2)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(nestedColumn2.children()).head())._2();
            }
            JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)fieldNames).add(topLevelColumnName2);
            return new Some((Object)new NestedFieldReferenceExpression((String[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class)), fieldIndices[0], TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(fieldAccess.getType()))));
        }
        throw new MatchError(option);
    }

    @Override
    public Option<ResolvedExpression> visitCorrelVariable(RexCorrelVariable correlVariable) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitRangeRef(RexRangeRef rangeRef) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitSubQuery(RexSubQuery subQuery) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitDynamicParam(RexDynamicParam dynamicParam) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitOver(RexOver over) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return None$.MODULE$;
    }

    private Option<ResolvedExpression> lookupFunction(UnresolvedIdentifier identifier, Seq<ResolvedExpression> operands, DataType outputType) {
        Success success;
        Optional f;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.functionCatalog.lookupFunction(identifier));
        if (try_ instanceof Success && (f = (Optional)(success = (Success)try_).value()) != null) {
            Optional optional = f;
            if (optional.isPresent()) {
                FunctionIdentifier functionIdentifier;
                ContextResolvedFunction resolvedFunction = (ContextResolvedFunction)optional.get();
                FunctionDefinition functionDefinition = resolvedFunction.getDefinition();
                if (functionDefinition instanceof BuiltInFunctionDefinition) {
                    BuiltInFunctionDefinition builtInFunctionDefinition = (BuiltInFunctionDefinition)functionDefinition;
                    functionIdentifier = FunctionIdentifier.of((String)builtInFunctionDefinition.getName());
                } else {
                    functionIdentifier = resolvedFunction.getIdentifier().orElse(null);
                }
                FunctionIdentifier identifier2 = functionIdentifier;
                return new Some((Object)new CallExpression(resolvedFunction.isTemporary(), identifier2, resolvedFunction.getDefinition(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(operands), outputType));
            }
            return None$.MODULE$;
        }
        if (try_ instanceof Failure) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private String replace(String str) {
        return str.replaceAll("\\s|_", "");
    }

    public RexNodeToExpressionConverter(RexBuilder rexBuilder, String[] inputNames, FunctionCatalog functionCatalog, CatalogManager catalogManager, Option<RelDataType> relDataType) {
        this.rexBuilder = rexBuilder;
        this.inputNames = inputNames;
        this.functionCatalog = functionCatalog;
        this.relDataType = relDataType;
    }

    public RexNodeToExpressionConverter(RexBuilder rexBuilder, String[] inputNames, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this(rexBuilder, inputNames, functionCatalog, catalogManager, (Option<RelDataType>)None$.MODULE$);
    }
}

