/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.planner.functions.sql.SqlTableArgOperator;

public class RexTableArgCall
extends RexCall {
    private final int inputIndex;
    private final int[] partitionKeys;
    private final int[] orderKeys;

    public RexTableArgCall(RelDataType type, int inputIndex, int[] partitionKeys, int[] orderKeys) {
        super(type, SqlTableArgOperator.INSTANCE, List.of());
        this.inputIndex = inputIndex;
        this.partitionKeys = partitionKeys;
        this.orderKeys = orderKeys;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int[] getPartitionKeys() {
        return this.partitionKeys;
    }

    public int[] getOrderKeys() {
        return this.orderKeys;
    }

    @Override
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        sb.append("#");
        sb.append(this.inputIndex);
        sb.append(")");
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        this.formatKeys(sb, this.partitionKeys, " PARTITION BY");
        this.formatKeys(sb, this.orderKeys, " ORDER BY");
        return sb.toString();
    }

    private void formatKeys(StringBuilder sb, int[] keys, String prefix) {
        if (keys.length == 0) {
            return;
        }
        sb.append(Arrays.stream(keys).mapToObj(key -> "$" + key).collect(Collectors.joining(", ", prefix + "(", ")")));
    }

    @Override
    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexTableArgCall(type, this.inputIndex, this.partitionKeys, this.orderKeys);
    }

    public RexTableArgCall copy(RelDataType type, int[] partitionKeys, int[] orderKeys) {
        return new RexTableArgCall(type, this.inputIndex, partitionKeys, orderKeys);
    }
}

