/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlConstraintValidator {
    public static List<SqlTableConstraint> getFullConstraints(List<SqlTableConstraint> tableConstraints, SqlNodeList columnList) {
        ArrayList<SqlTableConstraint> ret = new ArrayList<SqlTableConstraint>();
        columnList.forEach((Consumer<? super SqlNode>)((Consumer<SqlNode>)column -> {
            SqlTableColumn tableColumn = (SqlTableColumn)column;
            if (tableColumn instanceof SqlTableColumn.SqlRegularColumn) {
                SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)tableColumn;
                regularColumn.getConstraint().map(ret::add);
            }
        }));
        ret.addAll(tableConstraints);
        return ret;
    }

    public static void validateAndChangeColumnNullability(List<SqlTableConstraint> tableConstraints, SqlNodeList columnList) throws SqlValidateException {
        List<SqlTableConstraint> fullConstraints = SqlConstraintValidator.getFullConstraints(tableConstraints, columnList);
        if (fullConstraints.stream().filter(SqlTableConstraint::isPrimaryKey).count() > 1L) {
            throw new SqlValidateException(fullConstraints.get(1).getParserPosition(), "Duplicate primary key definition");
        }
        for (SqlTableConstraint constraint : fullConstraints) {
            SqlConstraintValidator.validate(constraint);
            Set primaryKeyColumns = Arrays.stream(constraint.getColumnNames()).collect(Collectors.toSet());
            for (SqlNode column : columnList) {
                SqlTableColumn tableColumn = (SqlTableColumn)column;
                if (!(tableColumn instanceof SqlTableColumn.SqlRegularColumn) || !primaryKeyColumns.contains(tableColumn.getName().getSimple())) continue;
                SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)column;
                SqlDataTypeSpec notNullType = regularColumn.getType().withNullable(false);
                regularColumn.setType(notNullType);
            }
        }
    }

    public static void validate(SqlTableConstraint constraint) throws SqlValidateException {
        if (constraint.isUnique()) {
            throw new SqlValidateException(constraint.getParserPosition(), "UNIQUE constraint is not supported yet");
        }
        if (constraint.isEnforced()) {
            throw new SqlValidateException(constraint.getParserPosition(), "Flink doesn't support ENFORCED mode for PRIMARY KEY constraint. ENFORCED/NOT ENFORCED controls if the constraint checks are performed on the incoming/outgoing data. Flink does not own the data therefore the only supported mode is the NOT ENFORCED mode");
        }
    }
}

