/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.lang.foreign.Arena;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

public final class DefaultMemoryRequestServer
implements MemoryRequestServer {
    private final long alignmentBytes;
    private final ByteOrder byteOrder;
    private final boolean oneArena;
    private final boolean offHeap;

    public DefaultMemoryRequestServer() {
        this.alignmentBytes = 8L;
        this.byteOrder = ByteOrder.nativeOrder();
        this.oneArena = false;
        this.offHeap = false;
    }

    public DefaultMemoryRequestServer(boolean oneArena, boolean offHeap) {
        this.alignmentBytes = 8L;
        this.byteOrder = ByteOrder.nativeOrder();
        this.oneArena = oneArena;
        this.offHeap = offHeap;
    }

    public DefaultMemoryRequestServer(long alignmentBytes, ByteOrder byteOrder, boolean oneArena, boolean offHeap) {
        this.alignmentBytes = alignmentBytes;
        this.byteOrder = byteOrder;
        this.oneArena = oneArena;
        this.offHeap = offHeap;
    }

    @Override
    public WritableMemory request(WritableMemory oldWmem, long newCapacityBytes) {
        if (oldWmem.getArena() == null || !this.offHeap) {
            if (newCapacityBytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Requested capacity exceeds Integer.MAX_VALUE.");
            }
            return WritableMemory.allocate((int)newCapacityBytes, this.byteOrder, this);
        }
        Arena arena = this.oneArena ? oldWmem.getArena() : Arena.ofConfined();
        return WritableMemory.allocateDirect(newCapacityBytes, this.alignmentBytes, this.byteOrder, this, arena);
    }

    @Override
    public void requestClose(WritableMemory wmemToClose) {
        Arena arena = wmemToClose.getArena();
        if (this.oneArena || arena == null || !arena.scope().isAlive()) {
            return;
        }
        arena.close();
    }
}

