/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.similarity.SimilarityInput;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimilarityInputTest {
    static SimilarityInput<Object> build(Class<?> fixtureClass, String value) {
        if (value == null) {
            return null;
        }
        try {
            return SimilarityInput.input(fixtureClass.getConstructor(String.class).newInstance(value));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static Stream<Class<?>> similarityInputs() {
        return Stream.of(SimilarityInputFixture.class, String.class, StringBuilder.class, StringBuffer.class, TextStringBuilder.class);
    }

    static Stream<Class<?>> similarityInputsEquals() {
        return Stream.of(SimilarityInputFixture.class, String.class, TextStringBuilder.class);
    }

    @Test
    void testInput() throws Exception {
        SimilarityInput input = SimilarityInput.input((CharSequence)"a");
        Assertions.assertEquals((int)1, (int)input.length());
        Assertions.assertThrows(IllegalArgumentException.class, () -> SimilarityInput.input((Object)new Object()));
    }

    public static final class SimilarityInputFixture
    implements SimilarityInput<Object> {
        private final CharSequence value;

        public SimilarityInputFixture(String value) {
            this.value = Objects.requireNonNull(value);
        }

        public Object at(int i) {
            return Character.valueOf(this.value.charAt(i));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimilarityInputFixture other = (SimilarityInputFixture)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public int length() {
            return this.value.length();
        }
    }
}

