/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathCompiledExpression;
import org.apache.commons.jxpath.ri.compiler.Constant;
import org.apache.commons.jxpath.ri.compiler.CoreFunction;
import org.apache.commons.jxpath.ri.compiler.CoreOperationAdd;
import org.apache.commons.jxpath.ri.compiler.CoreOperationAnd;
import org.apache.commons.jxpath.ri.compiler.CoreOperationDivide;
import org.apache.commons.jxpath.ri.compiler.CoreOperationEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationGreaterThan;
import org.apache.commons.jxpath.ri.compiler.CoreOperationGreaterThanOrEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationLessThan;
import org.apache.commons.jxpath.ri.compiler.CoreOperationLessThanOrEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationMod;
import org.apache.commons.jxpath.ri.compiler.CoreOperationMultiply;
import org.apache.commons.jxpath.ri.compiler.CoreOperationNegate;
import org.apache.commons.jxpath.ri.compiler.CoreOperationNotEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationOr;
import org.apache.commons.jxpath.ri.compiler.CoreOperationSubtract;
import org.apache.commons.jxpath.ri.compiler.CoreOperationUnion;
import org.apache.commons.jxpath.ri.compiler.ExpressionPath;
import org.apache.commons.jxpath.ri.compiler.ExtensionFunction;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.VariableReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JXPathCompiledExpressionTest
extends AbstractJXPathTest {
    private void assertXPathExpression(String xpath, Class expectedClass) {
        this.assertXPathExpression(xpath, expectedClass, xpath);
    }

    private void assertXPathExpression(String xpath, Class expectedClass, String expected) {
        JXPathCompiledExpression expression = (JXPathCompiledExpression)JXPathContext.compile((String)xpath);
        Assertions.assertEquals((Object)expectedClass, expression.getExpression().getClass(), (String)("Expression class for " + xpath));
        Assertions.assertEquals((Object)expected, (Object)expression.getExpression().toString(), (String)("Expression toString() for " + xpath));
    }

    @Test
    public void testConstant() {
        this.assertXPathExpression("1", Constant.class);
        this.assertXPathExpression("1.5", Constant.class);
        this.assertXPathExpression("'foo'", Constant.class);
    }

    @Test
    public void testCoreFunction() {
        this.assertXPathExpression("last()", CoreFunction.class);
        this.assertXPathExpression("position()", CoreFunction.class);
        this.assertXPathExpression("count(book)", CoreFunction.class);
        this.assertXPathExpression("id(13)", CoreFunction.class);
        this.assertXPathExpression("local-name()", CoreFunction.class);
        this.assertXPathExpression("local-name(book)", CoreFunction.class);
        this.assertXPathExpression("namespace-uri()", CoreFunction.class);
        this.assertXPathExpression("namespace-uri(book)", CoreFunction.class);
        this.assertXPathExpression("name()", CoreFunction.class);
        this.assertXPathExpression("name(book)", CoreFunction.class);
        this.assertXPathExpression("string(3)", CoreFunction.class);
        this.assertXPathExpression("concat('a', 'b')", CoreFunction.class);
        this.assertXPathExpression("starts-with('a', 'b')", CoreFunction.class);
        this.assertXPathExpression("ends-with('a', 'b')", CoreFunction.class);
        this.assertXPathExpression("contains('a', 'b')", CoreFunction.class);
        this.assertXPathExpression("substring-before('a', 1)", CoreFunction.class);
        this.assertXPathExpression("substring-after('a', 2)", CoreFunction.class);
        this.assertXPathExpression("substring('a', 2)", CoreFunction.class);
        this.assertXPathExpression("substring('a', 2, 3)", CoreFunction.class);
        this.assertXPathExpression("string-length('a')", CoreFunction.class);
        this.assertXPathExpression("normalize-space('a')", CoreFunction.class);
        this.assertXPathExpression("translate('a', 'b', 'c')", CoreFunction.class);
        this.assertXPathExpression("boolean('true')", CoreFunction.class);
        this.assertXPathExpression("not(1)", CoreFunction.class);
        this.assertXPathExpression("true()", CoreFunction.class);
        this.assertXPathExpression("false()", CoreFunction.class);
        this.assertXPathExpression("lang('fr')", CoreFunction.class);
        this.assertXPathExpression("number('12')", CoreFunction.class);
        this.assertXPathExpression("sum(book/price)", CoreFunction.class);
        this.assertXPathExpression("floor(11.4)", CoreFunction.class);
        this.assertXPathExpression("ceiling(11.4)", CoreFunction.class);
        this.assertXPathExpression("round(11.4)", CoreFunction.class);
        this.assertXPathExpression("key('title', 'Hobbit')", CoreFunction.class);
        this.assertXPathExpression("format-number(12, '##')", CoreFunction.class);
    }

    @Test
    public void testCoreOperationAnd() {
        this.assertXPathExpression("2 and 4", CoreOperationAnd.class);
        this.assertXPathExpression("2 > 1 and 4 < 5", CoreOperationAnd.class);
    }

    @Test
    public void testCoreOperationDivide() {
        this.assertXPathExpression("2 div 4", CoreOperationDivide.class);
        this.assertXPathExpression("2|3 div -3", CoreOperationDivide.class, "2 | 3 div -3");
    }

    @Test
    public void testCoreOperationEqual() {
        this.assertXPathExpression("2 = 4", CoreOperationEqual.class);
        this.assertXPathExpression("2 + 1 = 3", CoreOperationEqual.class);
    }

    @Test
    public void testCoreOperationGreaterThan() {
        this.assertXPathExpression("3>4", CoreOperationGreaterThan.class, "3 > 4");
        this.assertXPathExpression("3>(2>=1)", CoreOperationGreaterThan.class, "3 > (2 >= 1)");
        this.assertXPathExpression("1 > (1 and 2 <= (2 or 3) = 4)", CoreOperationGreaterThan.class);
    }

    @Test
    public void testCoreOperationGreaterThanOrEqual() {
        this.assertXPathExpression("3>=4", CoreOperationGreaterThanOrEqual.class, "3 >= 4");
        this.assertXPathExpression("3>=(2>=1)", CoreOperationGreaterThanOrEqual.class, "3 >= (2 >= 1)");
    }

    @Test
    public void testCoreOperationLessThan() {
        this.assertXPathExpression("3<4", CoreOperationLessThan.class, "3 < 4");
        this.assertXPathExpression("3<(2>=1)", CoreOperationLessThan.class, "3 < (2 >= 1)");
    }

    @Test
    public void testCoreOperationLessThanOrEqual() {
        this.assertXPathExpression("3<=4", CoreOperationLessThanOrEqual.class, "3 <= 4");
        this.assertXPathExpression("3<=(2>=1)", CoreOperationLessThanOrEqual.class, "3 <= (2 >= 1)");
    }

    @Test
    public void testCoreOperationMinus() {
        this.assertXPathExpression("1 - 1", CoreOperationSubtract.class);
        this.assertXPathExpression("1 - 1 - 2", CoreOperationSubtract.class);
        this.assertXPathExpression("1 - (1 - 2)", CoreOperationSubtract.class);
    }

    @Test
    public void testCoreOperationMod() {
        this.assertXPathExpression("2 mod 4", CoreOperationMod.class);
        this.assertXPathExpression("2|3 mod -3", CoreOperationMod.class, "2 | 3 mod -3");
    }

    @Test
    public void testCoreOperationMultiply() {
        this.assertXPathExpression("2*4", CoreOperationMultiply.class, "2 * 4");
        this.assertXPathExpression("2*(3 + 1)", CoreOperationMultiply.class, "2 * (3 + 1)");
    }

    @Test
    public void testCoreOperationNameAttributeTest() {
        this.assertXPathExpression("@name = 'bar'", NameAttributeTest.class);
    }

    @Test
    public void testCoreOperationNotEqual() {
        this.assertXPathExpression("2 != 4", CoreOperationNotEqual.class);
        this.assertXPathExpression("2 + 1 != 3", CoreOperationNotEqual.class);
    }

    @Test
    public void testCoreOperationOr() {
        this.assertXPathExpression("2 or 4", CoreOperationOr.class);
        this.assertXPathExpression("2 > 1 or 4 < 5", CoreOperationOr.class);
        this.assertXPathExpression("1 > 1 and 2 <= 2 or 3 = 4", CoreOperationOr.class);
    }

    @Test
    public void testCoreOperationSum() {
        this.assertXPathExpression("3 + 1 + 4", CoreOperationAdd.class);
        this.assertXPathExpression("(3 + 1) + 4", CoreOperationAdd.class, "3 + 1 + 4");
        this.assertXPathExpression("3 + (1 + 4)", CoreOperationAdd.class, "3 + 1 + 4");
        this.assertXPathExpression("3 + -1", CoreOperationAdd.class, "3 + -1");
        this.assertXPathExpression("2*-3 + -1", CoreOperationAdd.class, "2 * -3 + -1");
    }

    @Test
    public void testCoreOperationUnaryMinus() {
        this.assertXPathExpression("-3", CoreOperationNegate.class);
        this.assertXPathExpression("-(3 + 1)", CoreOperationNegate.class);
    }

    @Test
    public void testCoreOperationUnion() {
        this.assertXPathExpression("3 | 1 | 4", CoreOperationUnion.class);
    }

    @Test
    public void testExpressionPath() {
        this.assertXPathExpression("$x/foo/bar", ExpressionPath.class);
        this.assertXPathExpression("(2 + 2)/foo/bar", ExpressionPath.class);
        this.assertXPathExpression("$x[3][2 + 2]/foo/bar", ExpressionPath.class);
    }

    @Test
    public void testExtensionFunction() {
        this.assertXPathExpression("my:function(3, other.function())", ExtensionFunction.class);
    }

    @Test
    public void testLocationPathAxisAttribute() {
        this.assertXPathExpression("attribute::foo:bar", LocationPath.class, "@foo:bar");
        this.assertXPathExpression("@foo:bar", LocationPath.class);
        this.assertXPathExpression("../@foo:bar", LocationPath.class);
        this.assertXPathExpression("@*", LocationPath.class);
        this.assertXPathExpression("@*[last()]", LocationPath.class);
    }

    @Test
    public void testLocationPathAxisChild() {
        this.assertXPathExpression("child::foo:bar", LocationPath.class, "foo:bar");
        this.assertXPathExpression("foo:bar", LocationPath.class);
        this.assertXPathExpression("/foo:bar", LocationPath.class);
        this.assertXPathExpression("/foo/bar", LocationPath.class);
        this.assertXPathExpression("*", LocationPath.class);
        this.assertXPathExpression("foo:*", LocationPath.class);
    }

    @Test
    public void testLocationPathAxisDescendant() {
        this.assertXPathExpression("descendant::foo:bar", LocationPath.class);
    }

    @Test
    public void testLocationPathAxisDescendantOrSelf() {
        this.assertXPathExpression("descendant-or-self::foo:bar", LocationPath.class);
        this.assertXPathExpression("//foo", LocationPath.class);
        this.assertXPathExpression("foo//bar", LocationPath.class);
    }

    @Test
    public void testLocationPathAxisOther() {
        this.assertXPathExpression("ancestor::foo:bar", LocationPath.class);
        this.assertXPathExpression("ancestor-or-self::foo:bar", LocationPath.class);
        this.assertXPathExpression("namespace::foo:bar", LocationPath.class);
        this.assertXPathExpression("preceding::foo:bar", LocationPath.class);
        this.assertXPathExpression("preceding-sibling::foo:bar", LocationPath.class);
        this.assertXPathExpression("following::foo:bar", LocationPath.class);
        this.assertXPathExpression("following-sibling::foo:bar", LocationPath.class);
    }

    @Test
    public void testLocationPathAxisParent() {
        this.assertXPathExpression("parent::foo:bar", LocationPath.class);
        this.assertXPathExpression("..", LocationPath.class);
    }

    @Test
    public void testLocationPathAxisSelf() {
        this.assertXPathExpression("self::foo:bar", LocationPath.class);
        this.assertXPathExpression(".", LocationPath.class);
    }

    @Test
    public void testLocationPathNodeTest() {
        this.assertXPathExpression("node()", LocationPath.class);
        this.assertXPathExpression("text()", LocationPath.class);
        this.assertXPathExpression("comment()", LocationPath.class);
        this.assertXPathExpression("processing-instruction()", LocationPath.class);
        this.assertXPathExpression("processing-instruction('test')", LocationPath.class);
    }

    @Test
    public void testVariableReference() {
        this.assertXPathExpression("$x", VariableReference.class);
        this.assertXPathExpression("$x:y", VariableReference.class);
    }
}

