/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ZipArchiveOutputStreamTest
extends AbstractTempDirTest {
    ZipArchiveOutputStreamTest() {
    }

    @Test
    void testFileBasics() throws IOException {
        ZipArchiveOutputStream ref;
        try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(this.createTempFile());){
            ref = outputStream;
            Assertions.assertTrue((boolean)outputStream.isSeekable());
        }
        Assertions.assertTrue((boolean)ref.isClosed());
    }

    @Test
    void testOptionDefaults() throws IOException {
        ZipArchiveOutputStream ref;
        try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(this.createTempFile());){
            ref = outputStream;
            Assertions.assertTrue((boolean)outputStream.isSeekable());
            outputStream.setComment("");
            outputStream.setLevel(-1);
            outputStream.setMethod(8);
            outputStream.setFallbackToUTF8(false);
        }
        Assertions.assertTrue((boolean)ref.isClosed());
    }

    @Test
    void testOutputStreamBasics() throws IOException {
        try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());){
            Assertions.assertFalse((boolean)outputStream.isSeekable());
        }
    }

    @Test
    void testSetEncoding() throws IOException {
        try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(this.createTempFile());){
            outputStream.setEncoding(StandardCharsets.UTF_8.name());
            Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)outputStream.getEncoding());
            outputStream.setEncoding(null);
            Assertions.assertEquals((Object)Charset.defaultCharset().name(), (Object)outputStream.getEncoding());
        }
    }
}

