/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import java.net.InetSocketAddress;
import org.apache.cassandra.sidecar.adapters.base.CassandraAdapter;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.ICassandraAdapter;
import org.apache.cassandra.sidecar.common.server.ICassandraFactory;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.MinimumVersion;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.db.schema.TableSchemaFetcher;

@MinimumVersion(value="4.0.0")
public class CassandraFactory
implements ICassandraFactory {
    private final DnsResolver dnsResolver;
    private final DriverUtils driverUtils;
    private final TableSchemaFetcher tableSchemaFetcher;

    public CassandraFactory(DnsResolver dnsResolver, DriverUtils driverUtils, TableSchemaFetcher tableSchemaFetcher) {
        this.dnsResolver = dnsResolver;
        this.driverUtils = driverUtils;
        this.tableSchemaFetcher = tableSchemaFetcher;
    }

    public ICassandraAdapter create(CQLSessionProvider session, JmxClient jmxClient, InetSocketAddress localNativeTransportAddress) {
        return new CassandraAdapter(this.dnsResolver, jmxClient, session, localNativeTransportAddress, this.driverUtils, this.tableSchemaFetcher);
    }
}

