/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// PipeSpecApplyConfiguration represents an declarative configuration of the PipeSpec type for use
// with apply.
type PipeSpecApplyConfiguration struct {
	Integration        *IntegrationSpecApplyConfiguration  `json:"integration,omitempty"`
	Source             *EndpointApplyConfiguration         `json:"source,omitempty"`
	Sink               *EndpointApplyConfiguration         `json:"sink,omitempty"`
	ErrorHandler       *ErrorHandlerSpecApplyConfiguration `json:"errorHandler,omitempty"`
	Steps              []EndpointApplyConfiguration        `json:"steps,omitempty"`
	Replicas           *int32                              `json:"replicas,omitempty"`
	ServiceAccountName *string                             `json:"serviceAccountName,omitempty"`
}

// PipeSpecApplyConfiguration constructs an declarative configuration of the PipeSpec type for use with
// apply.
func PipeSpec() *PipeSpecApplyConfiguration {
	return &PipeSpecApplyConfiguration{}
}

// WithIntegration sets the Integration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Integration field is set to the value of the last call.
func (b *PipeSpecApplyConfiguration) WithIntegration(value *IntegrationSpecApplyConfiguration) *PipeSpecApplyConfiguration {
	b.Integration = value
	return b
}

// WithSource sets the Source field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Source field is set to the value of the last call.
func (b *PipeSpecApplyConfiguration) WithSource(value *EndpointApplyConfiguration) *PipeSpecApplyConfiguration {
	b.Source = value
	return b
}

// WithSink sets the Sink field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Sink field is set to the value of the last call.
func (b *PipeSpecApplyConfiguration) WithSink(value *EndpointApplyConfiguration) *PipeSpecApplyConfiguration {
	b.Sink = value
	return b
}

// WithErrorHandler sets the ErrorHandler field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ErrorHandler field is set to the value of the last call.
func (b *PipeSpecApplyConfiguration) WithErrorHandler(value *ErrorHandlerSpecApplyConfiguration) *PipeSpecApplyConfiguration {
	b.ErrorHandler = value
	return b
}

// WithSteps adds the given value to the Steps field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Steps field.
func (b *PipeSpecApplyConfiguration) WithSteps(values ...*EndpointApplyConfiguration) *PipeSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSteps")
		}
		b.Steps = append(b.Steps, *values[i])
	}
	return b
}

// WithReplicas sets the Replicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Replicas field is set to the value of the last call.
func (b *PipeSpecApplyConfiguration) WithReplicas(value int32) *PipeSpecApplyConfiguration {
	b.Replicas = &value
	return b
}

// WithServiceAccountName sets the ServiceAccountName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountName field is set to the value of the last call.
func (b *PipeSpecApplyConfiguration) WithServiceAccountName(value string) *PipeSpecApplyConfiguration {
	b.ServiceAccountName = &value
	return b
}
