/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction.strategies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.admin.compaction.CompactionConfigurer;
import org.apache.accumulo.core.client.admin.compaction.CompactionSelector;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.compaction.CompactionSettings;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.hadoop.fs.Path;

public class ConfigurableCompactionStrategy
implements CompactionSelector,
CompactionConfigurer {
    private List<Test> tests = new ArrayList<Test>();
    private boolean andTest = true;
    private int minFiles = 1;
    private Map<String, String> overrides = new HashMap<String, String>();

    public void init(CompactionConfigurer.InitParameters iparams) {
        Set es = iparams.getOptions().entrySet();
        block7: for (Map.Entry entry : es) {
            switch (CompactionSettings.valueOf((String)((String)entry.getKey()))) {
                case OUTPUT_COMPRESSION_OPT: {
                    this.overrides.put(Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), (String)entry.getValue());
                    continue block7;
                }
                case OUTPUT_BLOCK_SIZE_OPT: {
                    this.overrides.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), (String)entry.getValue());
                    continue block7;
                }
                case OUTPUT_INDEX_BLOCK_SIZE_OPT: {
                    this.overrides.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX.getKey(), (String)entry.getValue());
                    continue block7;
                }
                case OUTPUT_HDFS_BLOCK_SIZE_OPT: {
                    this.overrides.put(Property.TABLE_FILE_BLOCK_SIZE.getKey(), (String)entry.getValue());
                    continue block7;
                }
                case OUTPUT_REPLICATION_OPT: {
                    this.overrides.put(Property.TABLE_FILE_REPLICATION.getKey(), (String)entry.getValue());
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unknown option " + (String)entry.getKey());
        }
    }

    public CompactionConfigurer.Overrides override(CompactionConfigurer.InputParameters params) {
        return new CompactionConfigurer.Overrides(this.overrides);
    }

    public void init(CompactionSelector.InitParameters iparams) {
        boolean selectNoSummary = false;
        boolean selectExtraSummary = false;
        Set es = iparams.getOptions().entrySet();
        block10: for (Map.Entry entry : es) {
            switch (CompactionSettings.valueOf((String)((String)entry.getKey()))) {
                case SF_EXTRA_SUMMARY: {
                    selectExtraSummary = true;
                    continue block10;
                }
                case SF_NO_SUMMARY: {
                    selectNoSummary = true;
                    continue block10;
                }
                case SF_NO_SAMPLE: {
                    this.tests.add(new NoSampleTest());
                    continue block10;
                }
                case SF_LT_ESIZE_OPT: {
                    this.tests.add(new FileSizeTest((String)entry.getValue()){

                        @Override
                        public boolean shouldCompact(long fsize, long esize) {
                            return fsize < esize;
                        }
                    });
                    continue block10;
                }
                case SF_GT_ESIZE_OPT: {
                    this.tests.add(new FileSizeTest((String)entry.getValue()){

                        @Override
                        public boolean shouldCompact(long fsize, long esize) {
                            return fsize > esize;
                        }
                    });
                    continue block10;
                }
                case SF_NAME_RE_OPT: {
                    this.tests.add(new PatternPathTest((String)entry.getValue()){

                        @Override
                        public String getInput(Path path) {
                            return path.getName();
                        }
                    });
                    continue block10;
                }
                case SF_PATH_RE_OPT: {
                    this.tests.add(new PatternPathTest((String)entry.getValue()){

                        @Override
                        public String getInput(Path path) {
                            return path.toString();
                        }
                    });
                    continue block10;
                }
                case MIN_FILES_OPT: {
                    this.minFiles = Integer.parseInt((String)entry.getValue());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unknown option " + (String)entry.getKey());
        }
        if (selectExtraSummary || selectNoSummary) {
            this.tests.add(new SummaryTest(selectExtraSummary, selectNoSummary));
        }
    }

    public CompactionSelector.Selection select(CompactionSelector.SelectionParameters sparams) {
        Set<Object> filesToCompact = this.tests.isEmpty() ? new HashSet(sparams.getAvailableFiles()) : null;
        for (Test test : this.tests) {
            Set<CompactableFile> files = test.getFilesToCompact(sparams);
            if (filesToCompact == null) {
                filesToCompact = files;
                continue;
            }
            if (this.andTest) {
                filesToCompact.retainAll(files);
                continue;
            }
            filesToCompact.addAll(files);
        }
        if (filesToCompact.size() < this.minFiles) {
            return new CompactionSelector.Selection(Set.of());
        }
        return new CompactionSelector.Selection(filesToCompact);
    }

    private static class NoSampleTest
    extends Test {
        private NoSampleTest() {
        }

        @Override
        Set<CompactableFile> getFilesToCompact(CompactionSelector.SelectionParameters params) {
            SamplerConfigurationImpl sc = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)new ConfigurationCopy((Iterable)params.getEnvironment().getConfiguration(params.getTableId())));
            if (sc == null) {
                return Set.of();
            }
            HashSet<CompactableFile> filesToCompact = new HashSet<CompactableFile>();
            for (CompactableFile tabletFile : params.getAvailableFiles()) {
                Optional sample = params.getSample(tabletFile, sc.toSamplerConfiguration());
                if (!sample.isEmpty()) continue;
                filesToCompact.add(tabletFile);
            }
            return filesToCompact;
        }
    }

    private static class SummaryTest
    extends Test {
        private boolean selectExtraSummary;
        private boolean selectNoSummary;

        public SummaryTest(boolean selectExtraSummary, boolean selectNoSummary) {
            this.selectExtraSummary = selectExtraSummary;
            this.selectNoSummary = selectNoSummary;
        }

        @Override
        Set<CompactableFile> getFilesToCompact(CompactionSelector.SelectionParameters params) {
            Collection configs = SummarizerConfiguration.fromTableProperties((Iterable)params.getEnvironment().getConfiguration(params.getTableId()));
            if (configs.isEmpty()) {
                return Set.of();
            }
            HashSet<CompactableFile> filesToCompact = new HashSet<CompactableFile>();
            Set configsSet = configs instanceof Set ? (Set)configs : new HashSet(configs);
            block0: for (CompactableFile tabletFile : params.getAvailableFiles()) {
                HashMap<SummarizerConfiguration, Summary> sMap = new HashMap<SummarizerConfiguration, Summary>();
                Collection summaries = params.getSummaries(Collections.singletonList(tabletFile), configsSet::contains);
                for (Summary summary : summaries) {
                    sMap.put(summary.getSummarizerConfiguration(), summary);
                }
                for (SummarizerConfiguration sc : configs) {
                    Summary summary = (Summary)sMap.get(sc);
                    if (summary == null && this.selectNoSummary) {
                        filesToCompact.add(tabletFile);
                        continue block0;
                    }
                    if (summary == null || summary.getFileStatistics().getExtra() <= 0L || !this.selectExtraSummary) continue;
                    filesToCompact.add(tabletFile);
                    continue block0;
                }
            }
            return filesToCompact;
        }
    }

    private static abstract class Test {
        private Test() {
        }

        abstract Set<CompactableFile> getFilesToCompact(CompactionSelector.SelectionParameters var1);
    }

    private static abstract class PatternPathTest
    extends Test {
        private Pattern pattern;

        private PatternPathTest(String p) {
            this.pattern = Pattern.compile(p);
        }

        @Override
        Set<CompactableFile> getFilesToCompact(CompactionSelector.SelectionParameters params) {
            return params.getAvailableFiles().stream().filter(cf -> this.pattern.matcher(this.getInput(new Path(cf.getUri()))).matches()).collect(Collectors.toSet());
        }

        public abstract String getInput(Path var1);
    }

    private static abstract class FileSizeTest
    extends Test {
        private final long esize;

        private FileSizeTest(String s) {
            this.esize = Long.parseLong(s);
        }

        @Override
        Set<CompactableFile> getFilesToCompact(CompactionSelector.SelectionParameters params) {
            return params.getAvailableFiles().stream().filter(cf -> this.shouldCompact(cf.getEstimatedSize(), this.esize)).collect(Collectors.toSet());
        }

        public abstract boolean shouldCompact(long var1, long var3);
    }
}

