/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.LongStream;

public class MapCounter<KT> {
    private final HashMap<KT, MutableLong> map = new HashMap();

    public long increment(KT key, long l) {
        MutableLong ml = this.map.computeIfAbsent(key, KT -> new MutableLong());
        ml.l += l;
        if (ml.l == 0L) {
            this.map.remove(key);
        }
        return ml.l;
    }

    public long decrement(KT key, long l) {
        return this.increment(key, -1L * l);
    }

    public long get(KT key) {
        MutableLong ml = this.map.get(key);
        if (ml == null) {
            return 0L;
        }
        return ml.l;
    }

    public int getInt(KT key) {
        return Math.toIntExact(this.get(key));
    }

    public Set<KT> keySet() {
        return this.map.keySet();
    }

    public LongStream values() {
        return this.map.values().stream().mapToLong(mutLong -> mutLong.l);
    }

    public long max() {
        return this.values().max().orElse(0L);
    }

    public int size() {
        return this.map.size();
    }

    static class MutableLong {
        long l = 0L;

        MutableLong() {
        }
    }
}

