/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class IdentityCodec
implements CompressionCodec {
    public Compressor createCompressor() {
        return new IdentityCompressor();
    }

    public Decompressor createDecompressor() {
        return new IdentityDecompressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new IdentityCompressionInputStream(in);
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new IdentityCompressionInputStream(in);
    }

    public CompressionOutputStream createOutputStream(OutputStream os) throws IOException {
        return new IdentityCompressionOutputStream(os);
    }

    public CompressionOutputStream createOutputStream(OutputStream os, Compressor c) throws IOException {
        return new IdentityCompressionOutputStream(os);
    }

    public Class<? extends Compressor> getCompressorType() {
        return IdentityCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return IdentityDecompressor.class;
    }

    public String getDefaultExtension() {
        return ".identity";
    }

    public static class IdentityCompressor
    implements Compressor {
        private boolean finish;
        private boolean finished;
        private int nread;
        private int nwrite;
        private byte[] userBuf;
        private int userBufOff;
        private int userBufLen;

        public int compress(byte[] b, int off, int len) throws IOException {
            int n = Math.min(len, this.userBufLen);
            if (this.userBuf != null && b != null) {
                System.arraycopy(this.userBuf, this.userBufOff, b, off, n);
            }
            this.userBufOff += n;
            this.userBufLen -= n;
            this.nwrite += n;
            if (this.finish && this.userBufLen <= 0) {
                this.finished = true;
            }
            return n;
        }

        public void end() {
        }

        public void finish() {
            this.finish = true;
        }

        public boolean finished() {
            return this.finished;
        }

        public long getBytesRead() {
            return this.nread;
        }

        public long getBytesWritten() {
            return this.nwrite;
        }

        public boolean needsInput() {
            return this.userBufLen <= 0;
        }

        public void reset() {
            this.finish = false;
            this.finished = false;
            this.nread = 0;
            this.nwrite = 0;
            this.userBuf = null;
            this.userBufOff = 0;
            this.userBufLen = 0;
        }

        public void setDictionary(byte[] b, int off, int len) {
        }

        public void setInput(byte[] b, int off, int len) {
            this.nread += len;
            this.userBuf = b;
            this.userBufOff = off;
            this.userBufLen = len;
        }

        public void reinit(Configuration conf) {
        }
    }

    public static class IdentityDecompressor
    implements Decompressor {
        private boolean finish;
        private boolean finished;
        private int nread;
        private int nwrite;
        private byte[] userBuf;
        private int userBufOff;
        private int userBufLen;

        public int decompress(byte[] b, int off, int len) throws IOException {
            int n = Math.min(len, this.userBufLen);
            if (this.userBuf != null && b != null) {
                System.arraycopy(this.userBuf, this.userBufOff, b, off, n);
            }
            this.userBufOff += n;
            this.userBufLen -= n;
            this.nwrite += n;
            if (this.finish && this.userBufLen <= 0) {
                this.finished = true;
            }
            return n;
        }

        public void end() {
        }

        public boolean finished() {
            return this.finished;
        }

        public long getBytesRead() {
            return this.nread;
        }

        public long getBytesWritten() {
            return this.nwrite;
        }

        public boolean needsDictionary() {
            return false;
        }

        public boolean needsInput() {
            return this.userBufLen <= 0;
        }

        public void reset() {
            this.finish = false;
            this.finished = false;
            this.nread = 0;
            this.nwrite = 0;
            this.userBuf = null;
            this.userBufOff = 0;
            this.userBufLen = 0;
        }

        public void setDictionary(byte[] b, int off, int len) {
        }

        public void setInput(byte[] b, int off, int len) {
            this.nread += len;
            this.userBuf = b;
            this.userBufOff = off;
            this.userBufLen = len;
        }

        public int getRemaining() {
            return 0;
        }
    }

    public static class IdentityCompressionInputStream
    extends CompressionInputStream {
        protected IdentityCompressionInputStream(InputStream in) throws IOException {
            super(in);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void resetState() throws IOException {
        }

        public int read() throws IOException {
            return this.in.read();
        }
    }

    public static class IdentityCompressionOutputStream
    extends CompressionOutputStream {
        public IdentityCompressionOutputStream(OutputStream out) {
            super(out);
        }

        public void finish() throws IOException {
        }

        public void resetState() throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }
    }
}

