/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLock
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLock.class);
    private static final String ZLOCK_PREFIX = "zlock#";
    private final ServiceLockPath path;
    protected final ZooKeeper zooKeeper;
    private final Prefix vmLockPrefix;
    private LockWatcher lockWatcher;
    private String lockNodeName;
    private volatile boolean lockWasAcquired;
    private volatile boolean watchingParent;
    private String createdNodeName;
    private String watchingNodeName;

    public static ServiceLockPath path(String path) {
        return new ServiceLockPath(path);
    }

    public ServiceLock(ZooKeeper zookeeper, ServiceLockPath path, UUID uuid) {
        this.zooKeeper = Objects.requireNonNull(zookeeper);
        this.path = Objects.requireNonNull(path);
        try {
            this.zooKeeper.exists(path.toString(), (Watcher)this);
            this.watchingParent = true;
            this.vmLockPrefix = new Prefix(ZLOCK_PREFIX + uuid.toString() + "#");
        }
        catch (Exception ex) {
            LOG.error("Error setting initial watch", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized boolean tryLock(LockWatcher lw, byte[] data) throws KeeperException, InterruptedException {
        LockWatcherWrapper lww = new LockWatcherWrapper(lw);
        this.lock(lww, data);
        if (lww.acquiredLock) {
            return true;
        }
        if (this.createdNodeName != null) {
            String pathToDelete = String.valueOf(this.path) + "/" + this.createdNodeName;
            LOG.debug("[{}] Failed to acquire lock in tryLock(), deleting all at path: {}", (Object)this.vmLockPrefix, (Object)pathToDelete);
            ZooUtil.recursiveDelete(this.zooKeeper, pathToDelete, ZooUtil.NodeMissingPolicy.SKIP);
            this.createdNodeName = null;
        }
        return false;
    }

    public static List<String> validateAndSort(ServiceLockPath path, List<String> children) {
        LOG.trace("validating and sorting children at path {}", (Object)path);
        ArrayList<String> validChildren = new ArrayList<String>();
        if (children == null || children.isEmpty()) {
            return validChildren;
        }
        children.forEach(c -> {
            block10: {
                LOG.trace("Validating {}", c);
                if (c.startsWith(ZLOCK_PREFIX)) {
                    String candidate = c.substring(ZLOCK_PREFIX.length());
                    if (candidate.contains("#")) {
                        int idx = candidate.indexOf(35);
                        String uuid = candidate.substring(0, idx);
                        String sequenceNum = candidate.substring(idx + 1);
                        try {
                            LOG.trace("Testing uuid format of {}", (Object)uuid);
                            if (!uuid.equals(UUID.fromString(uuid).toString())) {
                                throw new IllegalArgumentException(uuid + " is an invalid UUID");
                            }
                            if (sequenceNum.length() == 10) {
                                try {
                                    LOG.trace("Testing number format of {}", (Object)sequenceNum);
                                    Integer.parseInt(sequenceNum);
                                    validChildren.add((String)c);
                                }
                                catch (NumberFormatException e) {
                                    LOG.warn("Child found with invalid sequence format: {} (not a number)", c);
                                }
                                break block10;
                            }
                            LOG.warn("Child found with invalid sequence format: {} (not 10 characters)", c);
                        }
                        catch (IllegalArgumentException e) {
                            LOG.warn("Child found with invalid UUID format: {}", c);
                        }
                    } else {
                        LOG.warn("Child found with invalid format: {} (does not contain second '#')", c);
                    }
                } else {
                    LOG.warn("Child found with invalid format: {} (does not start with {})", c, (Object)ZLOCK_PREFIX);
                }
            }
        });
        if (validChildren.size() > 1) {
            validChildren.sort((o1, o2) -> {
                int secondHashIdx = 43;
                return Integer.valueOf(o1.substring(secondHashIdx)).compareTo(Integer.valueOf(o2.substring(secondHashIdx)));
            });
        }
        LOG.trace("Children nodes (size: {}): {}", (Object)validChildren.size(), validChildren);
        return validChildren;
    }

    public static String findLowestPrevPrefix(List<String> children, String ephemeralNode) {
        int idx = children.indexOf(ephemeralNode);
        String prev = children.get(idx - 1);
        int prefixIdx = prev.lastIndexOf(35);
        String prevPrefix = prev.substring(0, prefixIdx);
        int i = 2;
        String lowestPrevNode = prev;
        while (idx - i >= 0) {
            prev = children.get(idx - i);
            ++i;
            if (!prev.startsWith(prevPrefix)) break;
            lowestPrevNode = prev;
        }
        return lowestPrevNode;
    }

    private synchronized void determineLockOwnership(final String createdEphemeralNode, final AccumuloLockWatcher lw) throws KeeperException, InterruptedException {
        if (this.createdNodeName == null) {
            throw new IllegalStateException("Called determineLockOwnership() when ephemeralNodeName == null");
        }
        List<String> children = ServiceLock.validateAndSort(this.path, this.zooKeeper.getChildren(this.path.toString(), null));
        if (!children.contains(createdEphemeralNode)) {
            LOG.error("Expected ephemeral node {} to be in the list of children {}", (Object)createdEphemeralNode, children);
            throw new RuntimeException("Lock attempt ephemeral node no longer exist " + createdEphemeralNode);
        }
        if (children.get(0).equals(createdEphemeralNode)) {
            LOG.debug("[{}] First candidate is my lock, acquiring...", (Object)this.vmLockPrefix);
            if (!this.watchingParent) {
                throw new IllegalStateException("Can not acquire lock, no longer watching parent : " + String.valueOf(this.path));
            }
            this.lockWatcher = lw;
            this.lockNodeName = createdEphemeralNode;
            this.createdNodeName = null;
            this.lockWasAcquired = true;
            lw.acquiredLock();
        } else {
            LOG.debug("[{}] Lock held by another process with ephemeral node: {}", (Object)this.vmLockPrefix, (Object)children.get(0));
            String lowestPrevNode = ServiceLock.findLowestPrevPrefix(children, createdEphemeralNode);
            this.watchingNodeName = String.valueOf(this.path) + "/" + lowestPrevNode;
            final String nodeToWatch = this.watchingNodeName;
            LOG.debug("[{}] Establishing watch on prior node {}", (Object)this.vmLockPrefix, (Object)nodeToWatch);
            Watcher priorNodeWatcher = new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    ServiceLock serviceLock;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("[{}] Processing {}", (Object)ServiceLock.this.vmLockPrefix, (Object)event);
                    }
                    boolean renew = true;
                    if (event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(nodeToWatch)) {
                        LOG.debug("[{}] Detected deletion of prior node {}, attempting to acquire lock; {}", new Object[]{ServiceLock.this.vmLockPrefix, nodeToWatch, event});
                        serviceLock = ServiceLock.this;
                        synchronized (serviceLock) {
                            block20: {
                                try {
                                    if (ServiceLock.this.createdNodeName != null) {
                                        ServiceLock.this.determineLockOwnership(createdEphemeralNode, lw);
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("[{}] While waiting for another lock {}, {} was deleted; {}", new Object[]{ServiceLock.this.vmLockPrefix, nodeToWatch, createdEphemeralNode, event});
                                    }
                                }
                                catch (Exception e) {
                                    if (ServiceLock.this.lockNodeName != null) break block20;
                                    lw.failedToAcquireLock(e);
                                }
                            }
                        }
                        renew = false;
                    }
                    if (event.getState() == Watcher.Event.KeeperState.Expired || event.getState() == Watcher.Event.KeeperState.Disconnected) {
                        serviceLock = ServiceLock.this;
                        synchronized (serviceLock) {
                            if (ServiceLock.this.lockNodeName == null) {
                                LOG.info("Zookeeper Session expired / disconnected; {}", (Object)event);
                                lw.failedToAcquireLock(new Exception("Zookeeper Session expired / disconnected; " + String.valueOf(event)));
                            }
                        }
                        renew = false;
                    }
                    if (renew) {
                        try {
                            Stat restat = ServiceLock.this.zooKeeper.exists(nodeToWatch, (Watcher)this);
                            if (restat == null) {
                                ServiceLock.this.zooKeeper.removeWatches(nodeToWatch, (Watcher)this, Watcher.WatcherType.Any, true);
                                ServiceLock.this.determineLockOwnership(createdEphemeralNode, lw);
                            } else {
                                LOG.debug("[{}] Renewed watch on prior node  {}", (Object)ServiceLock.this.vmLockPrefix, (Object)nodeToWatch);
                            }
                        }
                        catch (InterruptedException | KeeperException e) {
                            lw.failedToAcquireLock(new Exception("Failed to renew watch on other manager node", e));
                        }
                    }
                }
            };
            Stat stat = this.zooKeeper.exists(nodeToWatch, priorNodeWatcher);
            if (stat == null) {
                this.zooKeeper.removeWatches(nodeToWatch, priorNodeWatcher, Watcher.WatcherType.Any, true);
                this.determineLockOwnership(createdEphemeralNode, lw);
            }
        }
    }

    private void lostLock(LockLossReason reason) {
        LockWatcher localLw = this.lockWatcher;
        this.lockNodeName = null;
        this.lockWatcher = null;
        localLw.lostLock(reason);
    }

    public synchronized void lock(final AccumuloLockWatcher lw, byte[] data) {
        if (this.lockWatcher != null || this.lockNodeName != null || this.createdNodeName != null) {
            throw new IllegalStateException();
        }
        this.lockWasAcquired = false;
        try {
            String lockPathPrefix = String.valueOf(this.path) + "/" + this.vmLockPrefix.toString();
            String createPath = this.zooKeeper.create(lockPathPrefix, data, ZooUtil.PUBLIC, CreateMode.EPHEMERAL_SEQUENTIAL);
            LOG.debug("[{}] Ephemeral node {} created", (Object)this.vmLockPrefix, (Object)createPath);
            List<String> children = ServiceLock.validateAndSort(this.path, this.zooKeeper.getChildren(this.path.toString(), null));
            if (!children.contains(createPath.substring(this.path.toString().length() + 1))) {
                LOG.error("Expected ephemeral node {} to be in the list of children {}", (Object)createPath, children);
                throw new RuntimeException("Lock attempt ephemeral node no longer exist " + createPath);
            }
            Object lowestSequentialPath = null;
            boolean msgLoggedOnce = false;
            for (String child : children) {
                if (!child.startsWith(this.vmLockPrefix.toString())) continue;
                if (null == lowestSequentialPath) {
                    if (createPath.equals(String.valueOf(this.path) + "/" + child)) {
                        lowestSequentialPath = createPath;
                        break;
                    }
                    lowestSequentialPath = String.valueOf(this.path) + "/" + child;
                    LOG.debug("[{}] lowest sequential node found: {}", (Object)this.vmLockPrefix, lowestSequentialPath);
                    continue;
                }
                if (!msgLoggedOnce) {
                    LOG.info("[{}] Zookeeper client missed server response, multiple ephemeral child nodes created at {}", (Object)this.vmLockPrefix, (Object)lockPathPrefix);
                    msgLoggedOnce = true;
                }
                LOG.debug("[{}] higher sequential node found: {}, deleting it", (Object)this.vmLockPrefix, (Object)child);
                try {
                    this.zooKeeper.delete(String.valueOf(this.path) + "/" + child, -1);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) continue;
                    throw e;
                }
            }
            if (lowestSequentialPath == null) {
                throw new IllegalStateException("Could not find lowest sequential path under " + String.valueOf(this.path));
            }
            final String pathForWatcher = lowestSequentialPath;
            LOG.debug("[{}] Setting watcher on {}", (Object)this.vmLockPrefix, pathForWatcher);
            Watcher watcherForNodeWeCreated = new Watcher(){

                private void failedToAcquireLock() {
                    LOG.debug("[{}] Lock deleted before acquired, setting createdNodeName {} to null", (Object)ServiceLock.this.vmLockPrefix, (Object)ServiceLock.this.createdNodeName);
                    lw.failedToAcquireLock(new Exception("Lock deleted before acquired"));
                    ServiceLock.this.createdNodeName = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    ServiceLock serviceLock = ServiceLock.this;
                    synchronized (serviceLock) {
                        if (ServiceLock.this.lockNodeName != null && event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(String.valueOf(ServiceLock.this.path) + "/" + ServiceLock.this.lockNodeName)) {
                            LOG.debug("[{}] {} was deleted; {}", new Object[]{ServiceLock.this.vmLockPrefix, ServiceLock.this.lockNodeName, event});
                            ServiceLock.this.lostLock(LockLossReason.LOCK_DELETED);
                        } else if (ServiceLock.this.createdNodeName != null && event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(String.valueOf(ServiceLock.this.path) + "/" + ServiceLock.this.createdNodeName)) {
                            LOG.debug("[{}] {} was deleted; {}", new Object[]{ServiceLock.this.vmLockPrefix, ServiceLock.this.createdNodeName, event});
                            this.failedToAcquireLock();
                        } else if (event.getState() != Watcher.Event.KeeperState.Disconnected && event.getState() != Watcher.Event.KeeperState.Expired && (ServiceLock.this.lockNodeName != null || ServiceLock.this.createdNodeName != null)) {
                            LOG.debug("Unexpected event watching lock node {}; {}", (Object)pathForWatcher, (Object)event);
                            try {
                                Stat stat2 = ServiceLock.this.zooKeeper.exists(pathForWatcher, (Watcher)this);
                                if (stat2 == null) {
                                    ServiceLock.this.zooKeeper.removeWatches(pathForWatcher, (Watcher)this, Watcher.WatcherType.Any, true);
                                    if (ServiceLock.this.lockNodeName != null) {
                                        ServiceLock.this.lostLock(LockLossReason.LOCK_DELETED);
                                    } else if (ServiceLock.this.createdNodeName != null) {
                                        this.failedToAcquireLock();
                                    }
                                }
                            }
                            catch (Exception e) {
                                ServiceLock.this.lockWatcher.unableToMonitorLockNode(e);
                                LOG.error("Failed to stat lock node: {}; {}", new Object[]{pathForWatcher, event, e});
                            }
                        }
                    }
                }
            };
            Stat stat = this.zooKeeper.exists(pathForWatcher, watcherForNodeWeCreated);
            if (stat == null) {
                this.zooKeeper.removeWatches(pathForWatcher, watcherForNodeWeCreated, Watcher.WatcherType.Any, true);
                lw.failedToAcquireLock(new Exception("Lock does not exist after create"));
                return;
            }
            this.createdNodeName = pathForWatcher.substring(this.path.toString().length() + 1);
            this.determineLockOwnership(this.createdNodeName, lw);
        }
        catch (InterruptedException | KeeperException e) {
            lw.failedToAcquireLock((Exception)e);
        }
    }

    public synchronized boolean tryToCancelAsyncLockOrUnlock() throws InterruptedException, KeeperException {
        boolean del = false;
        if (this.createdNodeName != null) {
            String pathToDelete = String.valueOf(this.path) + "/" + this.createdNodeName;
            LOG.debug("[{}] Deleting all at path {} due to lock cancellation", (Object)this.vmLockPrefix, (Object)pathToDelete);
            ZooUtil.recursiveDelete(this.zooKeeper, pathToDelete, ZooUtil.NodeMissingPolicy.SKIP);
            del = true;
        }
        if (this.lockNodeName != null) {
            this.unlock();
            del = true;
        }
        return del;
    }

    public synchronized void unlock() throws InterruptedException, KeeperException {
        if (this.lockNodeName == null) {
            throw new IllegalStateException();
        }
        LockWatcher localLw = this.lockWatcher;
        String localLock = this.lockNodeName;
        this.lockNodeName = null;
        this.lockWatcher = null;
        String pathToDelete = String.valueOf(this.path) + "/" + localLock;
        LOG.debug("[{}] Deleting all at path {} due to unlock", (Object)this.vmLockPrefix, (Object)pathToDelete);
        ZooUtil.recursiveDelete(this.zooKeeper, pathToDelete, ZooUtil.NodeMissingPolicy.SKIP);
        localLw.lostLock(LockLossReason.LOCK_DELETED);
    }

    public synchronized String getWatching() {
        return this.watchingNodeName;
    }

    public synchronized String getLockPath() {
        if (this.lockNodeName == null) {
            return null;
        }
        return String.valueOf(this.path) + "/" + this.lockNodeName;
    }

    public synchronized String getLockName() {
        return this.lockNodeName;
    }

    public synchronized ZooUtil.LockID getLockID() {
        if (this.lockNodeName == null) {
            throw new IllegalStateException("Lock not held");
        }
        return new ZooUtil.LockID(this.path.toString(), this.lockNodeName, this.zooKeeper.getSessionId());
    }

    public synchronized boolean wasLockAcquired() {
        return this.lockWasAcquired;
    }

    public synchronized boolean isLocked() {
        return this.lockNodeName != null;
    }

    public synchronized void replaceLockData(byte[] b) throws KeeperException, InterruptedException {
        if (this.getLockPath() != null) {
            this.zooKeeper.setData(this.getLockPath(), b, -1);
        }
    }

    public synchronized void process(WatchedEvent event) {
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", (Object)event);
            }
            this.watchingParent = false;
            if (event.getState() == Watcher.Event.KeeperState.Expired && this.lockNodeName != null) {
                this.lostLock(LockLossReason.SESSION_EXPIRED);
            } else {
                try {
                    this.zooKeeper.exists(this.path.toString(), (Watcher)this);
                    this.watchingParent = true;
                }
                catch (KeeperException.ConnectionLossException ex) {
                    LOG.warn("lost connection to zookeeper", (Throwable)ex);
                }
                catch (Exception ex) {
                    if (this.lockNodeName == null && this.createdNodeName == null) break block6;
                    this.lockWatcher.unableToMonitorLockNode(ex);
                    LOG.error("Error resetting watch on ZooLock {} {}", new Object[]{this.lockNodeName != null ? this.lockNodeName : this.createdNodeName, event, ex});
                }
            }
        }
    }

    public static boolean isLockHeld(ZooCache zc, ZooUtil.LockID lid) {
        ServiceLockPath zLockPath = ServiceLock.path(lid.path);
        List<String> children = ServiceLock.validateAndSort(zLockPath, zc.getChildren(zLockPath.toString()));
        if (children.isEmpty()) {
            return false;
        }
        String lockNode = children.get(0);
        if (!lid.node.equals(lockNode)) {
            return false;
        }
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        return zc.get(lid.path + "/" + lid.node, stat) != null && stat.getEphemeralOwner() == lid.eid;
    }

    public static byte[] getLockData(ZooKeeper zk, ServiceLockPath path) throws KeeperException, InterruptedException {
        List<String> children = ServiceLock.validateAndSort(path, zk.getChildren(path.toString(), null));
        if (children.isEmpty()) {
            return null;
        }
        String lockNode = children.get(0);
        return zk.getData(String.valueOf(path) + "/" + lockNode, false, null);
    }

    public static byte[] getLockData(ZooCache zc, ServiceLockPath path, ZooCache.ZcStat stat) {
        List<String> children = ServiceLock.validateAndSort(path, zc.getChildren(path.toString()));
        if (children.isEmpty()) {
            return null;
        }
        String lockNode = children.get(0);
        if (!lockNode.startsWith(ZLOCK_PREFIX)) {
            throw new RuntimeException("Node " + lockNode + " at " + String.valueOf(path) + " is not a lock node");
        }
        return zc.get(String.valueOf(path) + "/" + lockNode, stat);
    }

    public static long getSessionId(ZooCache zc, ServiceLockPath path) {
        List<String> children = ServiceLock.validateAndSort(path, zc.getChildren(path.toString()));
        if (children.isEmpty()) {
            return 0L;
        }
        String lockNode = children.get(0);
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        if (zc.get(String.valueOf(path) + "/" + lockNode, stat) != null) {
            return stat.getEphemeralOwner();
        }
        return 0L;
    }

    public long getSessionId() throws KeeperException, InterruptedException {
        List<String> children = ServiceLock.validateAndSort(this.path, this.zooKeeper.getChildren(this.path.toString(), null));
        String lockNode = children.get(0);
        Stat stat = this.zooKeeper.exists(String.valueOf(this.path) + "/" + lockNode, null);
        if (null != stat) {
            return stat.getEphemeralOwner();
        }
        return 0L;
    }

    public static void deleteLock(ZooReaderWriter zk, ServiceLockPath path) throws InterruptedException, KeeperException {
        List<String> children = ServiceLock.validateAndSort(path, zk.getChildren(path.toString()));
        if (children.isEmpty()) {
            throw new IllegalStateException("No lock is held at " + String.valueOf(path));
        }
        String lockNode = children.get(0);
        if (!lockNode.startsWith(ZLOCK_PREFIX)) {
            throw new RuntimeException("Node " + lockNode + " at " + String.valueOf(path) + " is not a lock node");
        }
        String pathToDelete = String.valueOf(path) + "/" + lockNode;
        LOG.debug("Deleting all at path {} due to lock deletion", (Object)pathToDelete);
        zk.recursiveDelete(pathToDelete, ZooUtil.NodeMissingPolicy.SKIP);
    }

    public boolean verifyLockAtSource() {
        String lockPath = this.getLockPath();
        if (lockPath == null) {
            return false;
        }
        try {
            return null != this.zooKeeper.exists(lockPath, false);
        }
        catch (InterruptedException | RuntimeException | KeeperException e) {
            LOG.error("Error verfiying lock at {}", (Object)lockPath, (Object)e);
            return false;
        }
    }

    public static class ServiceLockPath {
        private final String path;

        private ServiceLockPath(String path) {
            this.path = Objects.requireNonNull(path);
        }

        public String toString() {
            return this.path;
        }
    }

    private static class Prefix {
        private final String prefix;

        public Prefix(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static class LockWatcherWrapper
    implements AccumuloLockWatcher {
        boolean acquiredLock = false;
        LockWatcher lw;

        public LockWatcherWrapper(LockWatcher lw2) {
            this.lw = lw2;
        }

        @Override
        public void acquiredLock() {
            this.acquiredLock = true;
        }

        @Override
        public void failedToAcquireLock(Exception e) {
            LOG.debug("Failed to acquire lock", (Throwable)e);
        }

        @Override
        public void lostLock(LockLossReason reason) {
            this.lw.lostLock(reason);
        }

        @Override
        public void unableToMonitorLockNode(Exception e) {
            this.lw.unableToMonitorLockNode(e);
        }
    }

    public static interface LockWatcher {
        public void lostLock(LockLossReason var1);

        public void unableToMonitorLockNode(Exception var1);
    }

    public static interface AccumuloLockWatcher
    extends LockWatcher {
        public void acquiredLock();

        public void failedToAcquireLock(Exception var1);
    }

    public static enum LockLossReason {
        LOCK_DELETED,
        SESSION_EXPIRED;

    }
}

