/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.compactor;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionStats;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.server.compaction.FileCompactor;

public class CompactionJobHolder {
    private TExternalCompactionJob job;
    private Thread compactionThread;
    private AtomicReference<FileCompactor> compactor;
    private volatile boolean cancelled = false;
    private volatile TCompactionStats stats = null;

    CompactionJobHolder() {
    }

    public synchronized void reset() {
        this.job = null;
        this.compactionThread = null;
        this.compactor = null;
        this.cancelled = false;
        this.stats = null;
    }

    public synchronized TExternalCompactionJob getJob() {
        return this.job;
    }

    public TableId getTableId() {
        TKeyExtent tKeyExtent = this.getJob().getExtent();
        return KeyExtent.fromThrift((TKeyExtent)tKeyExtent).tableId();
    }

    public TCompactionStats getStats() {
        return this.stats;
    }

    public void setStats(TCompactionStats stats) {
        this.stats = stats;
    }

    public synchronized boolean cancel(String extCompId) {
        if (this.isSet() && this.getJob().getExternalCompactionId().equals(extCompId)) {
            this.cancelled = true;
            if (this.compactor.get() != null) {
                this.compactor.get().interrupt();
            }
            this.compactionThread.interrupt();
            return true;
        }
        return false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isSet() {
        return null != this.job;
    }

    public synchronized void set(TExternalCompactionJob job, Thread compactionThread, AtomicReference<FileCompactor> compactor) {
        Objects.requireNonNull(job, "CompactionJob is null");
        Objects.requireNonNull(compactionThread, "Compaction thread is null");
        Objects.requireNonNull(compactor, "Compactor object is null");
        this.job = job;
        this.compactionThread = compactionThread;
        this.compactor = compactor;
    }
}

