/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class NamespacesCommand
extends Shell.Command {
    private Option disablePaginationOpt;
    private Option namespaceIdOption;
    private static final String DEFAULT_NAMESPACE_DISPLAY_NAME = "\"\"";

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        TreeMap namespaces = new TreeMap(shellState.getAccumuloClient().namespaceOperations().namespaceIdMap());
        Iterator it = Iterators.transform(namespaces.entrySet().iterator(), entry -> {
            String name = (String)entry.getKey();
            if (Namespace.DEFAULT.name().equals(name)) {
                name = DEFAULT_NAMESPACE_DISPLAY_NAME;
            }
            String id = (String)entry.getValue();
            if (cl.hasOption(this.namespaceIdOption.getOpt())) {
                return String.format("%-20s => %9s%n", name, id);
            }
            return name;
        });
        shellState.printLines(it, !cl.hasOption(this.disablePaginationOpt.getOpt()));
        return 0;
    }

    @Override
    public String description() {
        return "displays a list of all existing namespaces";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.namespaceIdOption = new Option("l", "list-ids", false, "display internal namespace ids along with the name");
        o.addOption(this.namespaceIdOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        o.addOption(this.disablePaginationOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

